/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txstate;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.procedures.ProcedureDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;

public interface TxStateVisitor {
    public void visitCreatedNode(long var1);

    public void visitDeletedNode(long var1);

    public void visitCreatedRelationship(long var1, int var3, long var4, long var6) throws ConstraintValidationKernelException;

    public void visitDeletedRelationship(long var1);

    public void visitNodePropertyChanges(long var1, Iterator<DefinedProperty> var3, Iterator<DefinedProperty> var4, Iterator<Integer> var5) throws ConstraintValidationKernelException;

    public void visitNodeRelationshipChanges(long var1, RelationshipChangesForNode var3, RelationshipChangesForNode var4);

    public void visitRelPropertyChanges(long var1, Iterator<DefinedProperty> var3, Iterator<DefinedProperty> var4, Iterator<Integer> var5) throws ConstraintValidationKernelException;

    public void visitGraphPropertyChanges(Iterator<DefinedProperty> var1, Iterator<DefinedProperty> var2, Iterator<Integer> var3);

    public void visitNodeLabelChanges(long var1, Set<Integer> var3, Set<Integer> var4) throws ConstraintValidationKernelException;

    public void visitAddedIndex(IndexDescriptor var1, boolean var2);

    public void visitRemovedIndex(IndexDescriptor var1, boolean var2);

    public void visitAddedUniquePropertyConstraint(UniquenessConstraint var1);

    public void visitRemovedUniquePropertyConstraint(UniquenessConstraint var1);

    public void visitAddedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint var1) throws CreateConstraintFailureException;

    public void visitRemovedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint var1);

    public void visitAddedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint var1) throws CreateConstraintFailureException;

    public void visitRemovedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint var1);

    public void visitCreatedLabelToken(String var1, int var2);

    public void visitCreatedPropertyKeyToken(String var1, int var2);

    public void visitCreatedRelationshipTypeToken(String var1, int var2);

    public void visitCreatedNodeLegacyIndex(String var1, Map<String, String> var2);

    public void visitCreatedRelationshipLegacyIndex(String var1, Map<String, String> var2);

    public void visitCreatedProcedure(ProcedureDescriptor var1);

    public void visitDroppedProcedure(ProcedureDescriptor var1);

    public static class Adapter
    implements TxStateVisitor {
        private final TxStateVisitor next;

        public Adapter(TxStateVisitor next) {
            this.next = next;
        }

        public Adapter() {
            this(null);
        }

        @Override
        public void visitCreatedNode(long id) {
            if (this.next != null) {
                this.next.visitCreatedNode(id);
            }
        }

        @Override
        public void visitDeletedNode(long id) {
            if (this.next != null) {
                this.next.visitDeletedNode(id);
            }
        }

        @Override
        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationKernelException {
            if (this.next != null) {
                this.next.visitCreatedRelationship(id, type, startNode, endNode);
            }
        }

        @Override
        public void visitDeletedRelationship(long id) {
            if (this.next != null) {
                this.next.visitDeletedRelationship(id);
            }
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) throws ConstraintValidationKernelException {
            if (this.next != null) {
                this.next.visitNodePropertyChanges(id, added, changed, removed);
            }
        }

        @Override
        public void visitNodeRelationshipChanges(long id, RelationshipChangesForNode added, RelationshipChangesForNode removed) {
            if (this.next != null) {
                this.next.visitNodeRelationshipChanges(id, added, removed);
            }
        }

        @Override
        public void visitRelPropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) throws ConstraintValidationKernelException {
            if (this.next != null) {
                this.next.visitRelPropertyChanges(id, added, changed, removed);
            }
        }

        @Override
        public void visitGraphPropertyChanges(Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
            if (this.next != null) {
                this.next.visitGraphPropertyChanges(added, changed, removed);
            }
        }

        @Override
        public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationKernelException {
            if (this.next != null) {
                this.next.visitNodeLabelChanges(id, added, removed);
            }
        }

        @Override
        public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
            if (this.next != null) {
                this.next.visitAddedIndex(element, isConstraintIndex);
            }
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
            if (this.next != null) {
                this.next.visitRemovedIndex(element, isConstraintIndex);
            }
        }

        @Override
        public void visitAddedUniquePropertyConstraint(UniquenessConstraint element) {
            if (this.next != null) {
                this.next.visitAddedUniquePropertyConstraint(element);
            }
        }

        @Override
        public void visitRemovedUniquePropertyConstraint(UniquenessConstraint element) {
            if (this.next != null) {
                this.next.visitRemovedUniquePropertyConstraint(element);
            }
        }

        @Override
        public void visitAddedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) throws CreateConstraintFailureException {
            if (this.next != null) {
                this.next.visitAddedNodePropertyExistenceConstraint(element);
            }
        }

        @Override
        public void visitRemovedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) {
            if (this.next != null) {
                this.next.visitRemovedNodePropertyExistenceConstraint(element);
            }
        }

        @Override
        public void visitAddedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) throws CreateConstraintFailureException {
            if (this.next != null) {
                this.next.visitAddedRelationshipPropertyExistenceConstraint(element);
            }
        }

        @Override
        public void visitRemovedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) {
            if (this.next != null) {
                this.next.visitRemovedRelationshipPropertyExistenceConstraint(element);
            }
        }

        @Override
        public void visitCreatedLabelToken(String name, int id) {
            if (this.next != null) {
                this.next.visitCreatedLabelToken(name, id);
            }
        }

        @Override
        public void visitCreatedPropertyKeyToken(String name, int id) {
            if (this.next != null) {
                this.next.visitCreatedPropertyKeyToken(name, id);
            }
        }

        @Override
        public void visitCreatedRelationshipTypeToken(String name, int id) {
            if (this.next != null) {
                this.next.visitCreatedRelationshipTypeToken(name, id);
            }
        }

        @Override
        public void visitCreatedNodeLegacyIndex(String name, Map<String, String> config) {
            if (this.next != null) {
                this.next.visitCreatedNodeLegacyIndex(name, config);
            }
        }

        @Override
        public void visitCreatedRelationshipLegacyIndex(String name, Map<String, String> config) {
            if (this.next != null) {
                this.next.visitCreatedRelationshipLegacyIndex(name, config);
            }
        }

        @Override
        public void visitCreatedProcedure(ProcedureDescriptor procedureDescriptor) {
            if (this.next != null) {
                this.next.visitCreatedProcedure(procedureDescriptor);
            }
        }

        @Override
        public void visitDroppedProcedure(ProcedureDescriptor procedureDescriptor) {
            if (this.next != null) {
                this.next.visitDroppedProcedure(procedureDescriptor);
            }
        }
    }
}

