/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.InitialStateFactory;

public interface InitialBranchState<STATE>
extends InitialStateFactory<STATE> {
    public static final InitialBranchState NO_STATE = new InitialBranchState(){

        @Override
        public Object initialState(Path path) {
            return null;
        }

        public InitialBranchState reverse() {
            return this;
        }
    };
    public static final InitialBranchState<Double> DOUBLE_ZERO = new InitialBranchState(){

        @Override
        public Number initialState(Path path) {
            return 0.0;
        }

        public InitialBranchState reverse() {
            return this;
        }
    };

    public InitialBranchState<STATE> reverse();

    public static class State<STATE>
    extends Adapter<STATE> {
        private final STATE initialState;
        private final STATE reversedInitialState;

        public State(STATE initialState, STATE reversedInitialState) {
            this.initialState = initialState;
            this.reversedInitialState = reversedInitialState;
        }

        @Override
        public InitialBranchState<STATE> reverse() {
            return new State<STATE>(this.reversedInitialState, this.initialState);
        }

        @Override
        public STATE initialState(Path path) {
            return this.initialState;
        }
    }

    public static abstract class Adapter<STATE>
    implements InitialBranchState<STATE> {
        @Override
        public InitialBranchState<STATE> reverse() {
            return this;
        }
    }
}

