/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.logging.LogMarker;

public abstract class StringLogger {
    public static final String DEFAULT_NAME = "messages.log";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final StringLogger SYSTEM = StringLogger.instantiateStringLoggerForPrintStream(System.out, false);
    public static final StringLogger SYSTEM_ERR = StringLogger.instantiateStringLoggerForPrintStream(System.err, false);
    public static final StringLogger SYSTEM_DEBUG = StringLogger.instantiateStringLoggerForPrintStream(System.out, true);
    public static final StringLogger SYSTEM_ERR_DEBUG = StringLogger.instantiateStringLoggerForPrintStream(System.err, true);
    public static final int DEFAULT_THRESHOLD_FOR_ROTATION = 0x6400000;
    private static final int NUMBER_OF_OLD_LOGS_TO_KEEP = 2;
    public static final StringLogger DEV_NULL = new StringLogger(){

        @Override
        public void doDebug(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
        }

        @Override
        public void info(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
        }

        @Override
        public void warn(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
        }

        @Override
        public void error(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
        }

        @Override
        public void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source, boolean flush) {
        }

        @Override
        protected void logLine(String line) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void addRotationListener(Runnable listener) {
        }
    };

    private static ActualStringLogger instantiateStringLoggerForPrintStream(PrintStream stream, boolean debugEnabled) {
        PrintWriter writer;
        try {
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)stream, DEFAULT_ENCODING), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new ActualStringLogger(writer, debugEnabled){

            @Override
            public void close() {
            }
        };
    }

    public static StringLogger logger(File logfile) {
        try {
            return new ActualStringLogger(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logfile, true), DEFAULT_ENCODING)), false);
        }
        catch (IOException cause) {
            throw new RuntimeException("Could not create log file: " + logfile, cause);
        }
    }

    public static StringLogger logger(FileSystemAbstraction fileSystem, File logFile, int rotationThreshold, boolean debugEnabled) {
        return new ActualStringLogger(fileSystem, logFile.getPath(), rotationThreshold, debugEnabled);
    }

    public static StringLogger loggerDirectory(FileSystemAbstraction fileSystem, File logDirectory) {
        return StringLogger.loggerDirectory(fileSystem, logDirectory, 0x6400000, false);
    }

    public static StringLogger loggerDirectory(FileSystemAbstraction fileSystem, File logDirectory, int rotationThreshold, boolean debugEnabled) {
        return new ActualStringLogger(fileSystem, new File(logDirectory, DEFAULT_NAME).getPath(), rotationThreshold, debugEnabled);
    }

    public static StringLogger wrap(Writer writer) {
        return new ActualStringLogger(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), false);
    }

    public static StringLogger wrap(final StringBuffer target) {
        return new ActualStringLogger(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                target.append(cbuf, off, len);
            }

            @Override
            public void write(int c) throws IOException {
                target.appendCodePoint(c);
            }

            @Override
            public void write(char[] cbuf) throws IOException {
                target.append(cbuf);
            }

            @Override
            public void write(String str) throws IOException {
                target.append(str);
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                target.append(str, off, len);
            }

            @Override
            public Writer append(char c) throws IOException {
                target.append(c);
                return this;
            }

            @Override
            public Writer append(CharSequence csq) throws IOException {
                target.append(csq);
                return this;
            }

            @Override
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                target.append(csq, start, end);
                return this;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }), false);
    }

    public static StringLogger tee(final StringLogger logger1, final StringLogger logger2) {
        return new StringLogger(){

            @Override
            protected void doDebug(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                logger1.doDebug(msg, cause, flush, logMarker);
                logger2.doDebug(msg, cause, flush, logMarker);
            }

            @Override
            public void info(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                logger1.info(msg, cause, flush, logMarker);
                logger2.info(msg, cause, flush, logMarker);
            }

            @Override
            public void warn(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                logger1.warn(msg, cause, flush, logMarker);
                logger2.warn(msg, cause, flush, logMarker);
            }

            @Override
            public void error(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                logger1.error(msg, cause, flush, logMarker);
                logger2.error(msg, cause, flush, logMarker);
            }

            @Override
            public void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source, boolean flush) {
                logger1.logLongMessage(msg, source, flush);
                logger2.logLongMessage(msg, source, flush);
            }

            @Override
            public void addRotationListener(Runnable listener) {
                logger1.addRotationListener(listener);
                logger2.addRotationListener(listener);
            }

            @Override
            public void flush() {
                logger1.flush();
                logger2.flush();
            }

            @Override
            public void close() {
                logger1.close();
                logger2.close();
            }

            @Override
            protected void logLine(String line) {
                logger1.logLine(line);
                logger2.logLine(line);
            }
        };
    }

    public static StringLogger lazyLogger(final File logFile) {
        return new StringLogger(){
            StringLogger logger = null;

            @Override
            public void doDebug(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                this.createLogger();
                this.logger.doDebug(msg, cause, flush, logMarker);
            }

            @Override
            public void info(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                this.createLogger();
                this.logger.info(msg, cause, flush, logMarker);
            }

            @Override
            public void warn(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                this.createLogger();
                this.logger.warn(msg, cause, flush, logMarker);
            }

            @Override
            public void error(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                this.createLogger();
                this.logger.error(msg, cause, flush, logMarker);
            }

            @Override
            public void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source, boolean flush) {
                this.createLogger();
                this.logger.logLongMessage(msg, source, flush);
            }

            @Override
            public void addRotationListener(Runnable listener) {
                this.createLogger();
                this.logger.addRotationListener(listener);
            }

            @Override
            public void flush() {
                this.createLogger();
                this.logger.flush();
            }

            @Override
            public void close() {
                if (this.logger != null) {
                    this.logger.close();
                }
            }

            @Override
            protected void logLine(String line) {
                this.createLogger();
                this.logger.logLine(line);
            }

            private synchronized void createLogger() {
                if (this.logger == null) {
                    this.logger = 4.logger(logFile);
                }
            }
        };
    }

    public final void debug(String msg) {
        this.debug(msg, null);
    }

    public final void debug(String msg, boolean flush) {
        this.debug(msg, null, flush);
    }

    public final void debug(String msg, Throwable cause) {
        this.debug(msg, cause, false);
    }

    public final void debug(String msg, Throwable cause, boolean flush) {
        this.debug(msg, cause, flush, LogMarker.NO_MARK);
    }

    public final void debug(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
        if (this.isDebugEnabled()) {
            this.doDebug(msg, cause, flush, logMarker);
        }
    }

    protected abstract void doDebug(String var1, Throwable var2, boolean var3, LogMarker var4);

    public boolean isDebugEnabled() {
        return false;
    }

    public final void info(String msg) {
        this.info(msg, null);
    }

    public final void info(String msg, boolean flush) {
        this.info(msg, null, flush);
    }

    public final void info(String msg, Throwable cause) {
        this.info(msg, cause, false);
    }

    public final void info(String msg, Throwable cause, boolean flush) {
        this.info(msg, cause, flush, LogMarker.NO_MARK);
    }

    public abstract void info(String var1, Throwable var2, boolean var3, LogMarker var4);

    public final void warn(String msg) {
        this.warn(msg, null);
    }

    public final void warn(String msg, boolean flush) {
        this.warn(msg, null, flush);
    }

    public final void warn(String msg, Throwable cause) {
        this.warn(msg, cause, false);
    }

    public final void warn(String msg, Throwable cause, boolean flush) {
        this.warn(msg, cause, flush, LogMarker.NO_MARK);
    }

    public abstract void warn(String var1, Throwable var2, boolean var3, LogMarker var4);

    public final void error(String msg) {
        this.error(msg, null);
    }

    public final void error(String msg, boolean flush) {
        this.error(msg, null, flush);
    }

    public final void error(String msg, Throwable cause) {
        this.error(msg, cause, false);
    }

    public final void error(String msg, Throwable cause, boolean flush) {
        this.error(msg, cause, flush, LogMarker.NO_MARK);
    }

    public abstract void error(String var1, Throwable var2, boolean var3, LogMarker var4);

    public void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source) {
        this.logLongMessage(msg, source, false);
    }

    public void logLongMessage(String msg, Iterable<String> source) {
        this.logLongMessage(msg, source, false);
    }

    public void logLongMessage(String msg, Iterable<String> source, boolean flush) {
        this.logLongMessage(msg, source.iterator(), flush);
    }

    public void logLongMessage(String msg, Iterator<String> source) {
        this.logLongMessage(msg, source, false);
    }

    public void logLongMessage(String msg, final Iterator<String> source, boolean flush) {
        this.logLongMessage(msg, new Visitor<LineLogger, RuntimeException>(){

            @Override
            public boolean visit(LineLogger logger) {
                for (String line : IteratorUtil.loop(source)) {
                    logger.logLine(line);
                }
                return true;
            }
        }, flush);
    }

    public abstract void logLongMessage(String var1, Visitor<LineLogger, RuntimeException> var2, boolean var3);

    public abstract void addRotationListener(Runnable var1);

    public abstract void flush();

    public abstract void close();

    protected abstract void logLine(String var1);

    protected static final class LineLoggerImpl
    implements LineLogger {
        private final StringLogger target;

        public LineLoggerImpl(StringLogger target) {
            this.target = target;
        }

        @Override
        public void logLine(String line) {
            this.target.logLine(line);
        }
    }

    private static class ActualStringLogger
    extends StringLogger {
        private static final String encoding = "UTF-8";
        private PrintWriter out;
        private final Integer rotationThreshold;
        private final File file;
        private final List<Runnable> onRotation = new CopyOnWriteArrayList<Runnable>();
        private final FileSystemAbstraction fileSystem;
        private final boolean debugEnabled;
        private volatile boolean doingRotation = false;

        private ActualStringLogger(FileSystemAbstraction fileSystem, String filename, int rotationThreshold, boolean debugEnabled) {
            this.fileSystem = fileSystem;
            this.rotationThreshold = rotationThreshold;
            this.debugEnabled = debugEnabled;
            try {
                this.file = new File(filename);
                if (this.file.getParentFile() != null) {
                    fileSystem.mkdirs(this.file.getParentFile());
                }
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ActualStringLogger(PrintWriter writer, boolean debugEnabled) {
            this.out = writer;
            this.rotationThreshold = null;
            this.file = null;
            this.fileSystem = null;
            this.debugEnabled = debugEnabled;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.debugEnabled;
        }

        @Override
        protected void doDebug(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.doLogMessage(msg, cause, flush, logMarker, "DEBUG");
        }

        @Override
        public void info(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.doLogMessage(msg, cause, flush, logMarker, "INFO");
        }

        @Override
        public void warn(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.doLogMessage(msg, cause, flush, logMarker, "WARN");
        }

        @Override
        public void error(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.doLogMessage(msg, cause, flush, logMarker, "ERROR");
        }

        private synchronized void doLogMessage(String msg, Throwable cause, boolean flush, LogMarker ignored, String level) {
            String message = this.time();
            message = cause != null ? message + " " + level + " [org.neo4j]: " + msg + " " + cause.getMessage() : message + " " + level + "  [org.neo4j]: " + msg;
            this.out.println(message);
            if (cause != null) {
                cause.printStackTrace(this.out);
            }
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        @Override
        public void addRotationListener(Runnable trigger) {
            this.onRotation.add(trigger);
        }

        private void instantiateWriter() throws IOException {
            this.out = new PrintWriter(new OutputStreamWriter(this.fileSystem.openAsOutputStream(this.file, true), "UTF-8"));
            for (Runnable trigger : this.onRotation) {
                trigger.run();
            }
        }

        private String time() {
            return Format.date();
        }

        @Override
        public synchronized void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source, boolean flush) {
            this.out.println(this.time() + " INFO  [org.neo4j]: " + msg);
            source.visit(new LineLoggerImpl(this));
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        @Override
        protected void logLine(String line) {
            this.out.println("    " + line);
        }

        private void checkRotation() {
            if (this.rotationThreshold != null && this.fileSystem.getFileSize(this.file) > (long)this.rotationThreshold.intValue() && !this.doingRotation) {
                this.doRotation();
            }
        }

        private void doRotation() {
            this.doingRotation = true;
            this.out.close();
            this.moveAwayFile();
            try {
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.doingRotation = false;
            }
        }

        private void moveAwayFile() {
            File oldLogFile = new File(this.file.getParentFile(), this.file.getName() + "." + 2);
            if (this.fileSystem.fileExists(oldLogFile)) {
                this.fileSystem.deleteFile(oldLogFile);
            }
            for (int i = 1; i >= 0; --i) {
                oldLogFile = new File(this.file.getParentFile(), this.file.getName() + (i == 0 ? "" : "." + i));
                if (!this.fileSystem.fileExists(oldLogFile)) continue;
                try {
                    this.fileSystem.renameFile(oldLogFile, new File(this.file.getParentFile(), this.file.getName() + "." + (i + 1)));
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void flush() {
            this.out.flush();
        }

        @Override
        public void close() {
            this.out.close();
        }

        public String toString() {
            return "StringLogger[" + this.file + "]";
        }
    }

    public static interface LineLogger {
        public void logLine(String var1);
    }
}

