/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Arrays;

public final class Bits
implements Cloneable {
    private final long[] longs;
    private final int numberOfBytes;
    private int writePosition;
    private int readPosition;
    private static final long[] RIGHT_OVERFLOW_MASKS = new long[64];

    public static Bits bits(int numberOfBytes) {
        int requiredLongs = Bits.requiredLongs(numberOfBytes);
        return new Bits(new long[requiredLongs], numberOfBytes);
    }

    public static int requiredLongs(int numberOfBytes) {
        return (numberOfBytes - 1 >> 3) + 1;
    }

    public static Bits bitsFromLongs(long[] longs) {
        return new Bits(longs, longs.length << 3);
    }

    public static Bits bitsFromBytes(byte[] bytes) {
        return Bits.bitsFromBytes(bytes, 0);
    }

    public static Bits bitsFromBytes(byte[] bytes, int startIndex) {
        int count = bytes.length;
        Bits bits = Bits.bits(count - startIndex);
        for (int i = startIndex; i < count; ++i) {
            bits.put(bytes[i]);
        }
        return bits;
    }

    private Bits(long[] longs, int numberOfBytes) {
        this.longs = longs;
        this.numberOfBytes = numberOfBytes;
    }

    public static long leftOverflowMask(int steps) {
        long mask = 0L;
        for (int i = 0; i < steps; ++i) {
            mask >>= 1;
            mask |= Long.MIN_VALUE;
        }
        return mask;
    }

    public static long rightOverflowMask(int steps) {
        return RIGHT_OVERFLOW_MASKS[steps - 1];
    }

    public long[] getLongs() {
        return this.longs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] asBytes() {
        int readPositionBefore = this.readPosition;
        this.readPosition = 0;
        try {
            byte[] result = new byte[this.numberOfBytes];
            int count = result.length;
            for (int i = 0; i < count; ++i) {
                result[i] = this.getByte();
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            this.readPosition = readPositionBefore;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int longIndex = this.longs.length - 1; longIndex >= 0; --longIndex) {
            long value = this.longs[longIndex];
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(longIndex);
            builder.append(':');
            Bits.numberToString(builder, value, 8);
            if (longIndex != 0) continue;
            builder.append(" <-- START");
        }
        return builder.toString();
    }

    public static StringBuilder numberToString(StringBuilder builder, long value, int numberOfBytes) {
        builder.append("[");
        for (int i = 8 * numberOfBytes - 1; i >= 0; --i) {
            if (i > 0 && i % 8 == 0) {
                builder.append(",");
            }
            boolean isSet = (value & 1L << i) != 0L;
            builder.append(isSet ? "1" : "0");
        }
        builder.append("]");
        return builder;
    }

    public static String numbersToBitString(byte[] values) {
        StringBuilder builder = new StringBuilder();
        for (byte value : values) {
            Bits.numberToString(builder, value, 1);
        }
        return builder.toString();
    }

    public static String numbersToBitString(short[] values) {
        StringBuilder builder = new StringBuilder();
        for (short value : values) {
            Bits.numberToString(builder, value, 2);
        }
        return builder.toString();
    }

    public static String numbersToBitString(int[] values) {
        StringBuilder builder = new StringBuilder();
        for (int value : values) {
            Bits.numberToString(builder, value, 4);
        }
        return builder.toString();
    }

    public static String numbersToBitString(long[] values) {
        StringBuilder builder = new StringBuilder();
        for (long value : values) {
            Bits.numberToString(builder, value, 8);
        }
        return builder.toString();
    }

    public Bits clone() {
        return new Bits(Arrays.copyOf(this.longs, this.longs.length), this.numberOfBytes);
    }

    public Bits put(byte value) {
        return this.put(value, 8);
    }

    public Bits put(byte value, int steps) {
        return this.put((long)value, steps);
    }

    public Bits put(short value) {
        return this.put(value, 16);
    }

    public Bits put(short value, int steps) {
        return this.put((long)value, steps);
    }

    public Bits put(int value) {
        return this.put(value, 32);
    }

    public Bits put(int value, int steps) {
        return this.put((long)value, steps);
    }

    public Bits put(long value) {
        return this.put(value, 64);
    }

    public Bits put(long value, int steps) {
        int lowLongIndex = this.writePosition >> 6;
        int lowBitInLong = this.writePosition % 64;
        int lowBitsAvailable = 64 - lowBitInLong;
        long lowValueMask = Bits.rightOverflowMask(Math.min(lowBitsAvailable, steps));
        int n = lowLongIndex;
        this.longs[n] = this.longs[n] | (value & lowValueMask) << lowBitInLong;
        if (steps > lowBitsAvailable) {
            long highValueMask = Bits.rightOverflowMask(steps - lowBitsAvailable);
            int n2 = lowLongIndex + 1;
            this.longs[n2] = this.longs[n2] | value >>> lowBitsAvailable & highValueMask;
        }
        this.writePosition += steps;
        return this;
    }

    public boolean available() {
        return this.readPosition < this.writePosition;
    }

    public byte getByte() {
        return this.getByte(8);
    }

    public byte getByte(int steps) {
        return (byte)this.getLong(steps);
    }

    public short getShort() {
        return this.getShort(16);
    }

    public short getShort(int steps) {
        return (short)this.getLong(steps);
    }

    public int getInt() {
        return this.getInt(32);
    }

    public int getInt(int steps) {
        return (int)this.getLong(steps);
    }

    public long getUnsignedInt() {
        return (long)this.getInt(32) & 0xFFFFFFFFL;
    }

    public long getLong() {
        return this.getLong(64);
    }

    public long getLong(int steps) {
        int lowLongIndex = this.readPosition >> 6;
        int lowBitInLong = this.readPosition % 64;
        int lowBitsAvailable = 64 - lowBitInLong;
        long lowLongMask = Bits.rightOverflowMask(Math.min(lowBitsAvailable, steps)) << lowBitInLong;
        long lowValue = this.longs[lowLongIndex] & lowLongMask;
        long result = lowValue >>> lowBitInLong;
        if (steps > lowBitsAvailable) {
            long highLongMask = Bits.rightOverflowMask(steps - lowBitsAvailable);
            result |= (this.longs[lowLongIndex + 1] & highLongMask) << lowBitsAvailable;
        }
        this.readPosition += steps;
        return result;
    }

    public static boolean bitFlag(byte flags, byte flag) {
        assert ((flag & -flag) == flag) : "flag should be a power of 2, not: 0x" + Integer.toHexString(flag);
        return (flags & flag) == flag;
    }

    public static byte bitFlag(boolean value, byte flag) {
        assert ((flag & -flag) == flag) : "flag should be a power of 2, not: 0x" + Integer.toHexString(flag);
        return value ? flag : (byte)0;
    }

    public static byte notFlag(byte flags, byte flag) {
        assert ((flag & -flag) == flag) : "flag should be a power of 2, not: 0x" + Integer.toHexString(flag);
        return (byte)(flags & ~flag);
    }

    public static byte bitFlags(byte ... flags) {
        byte result = 0;
        for (byte flag : flags) {
            result = (byte)(result | flag);
        }
        return result;
    }

    public void clear(boolean zeroBits) {
        if (zeroBits) {
            Arrays.fill(this.longs, 0L);
        }
        this.writePosition = 0;
        this.readPosition = 0;
    }

    public int longsInUse() {
        return (this.writePosition - 1) / 64 + 1;
    }

    static {
        long mask = 1L;
        for (int i = 0; i < RIGHT_OVERFLOW_MASKS.length; ++i) {
            Bits.RIGHT_OVERFLOW_MASKS[i] = mask;
            mask <<= 1;
            mask |= 1L;
        }
    }
}

