/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;

public class VersionAwareLogEntryReader<SOURCE extends ReadableLogChannel>
implements LogEntryReader<SOURCE> {
    private final LogPositionMarker positionMarker = new LogPositionMarker();
    private final byte logHeaderFormatVersion;
    private LogEntryVersion lastVersion;
    private CommandReader currentCommandReader;

    public VersionAwareLogEntryReader(byte logHeaderFormatVersion) {
        this.logHeaderFormatVersion = logHeaderFormatVersion;
    }

    public VersionAwareLogEntryReader() {
        this(-1);
    }

    @Override
    public LogEntry readLogEntry(SOURCE channel) throws IOException {
        try {
            LogEntry entry;
            LogEntryParser<LogEntry> entryReader;
            channel.getCurrentPosition(this.positionMarker);
            do {
                CommandReader commandReader;
                LogEntryVersion version = null;
                try {
                    byte typeCode = channel.get();
                    byte versionCode = 0;
                    if (typeCode < 0) {
                        versionCode = typeCode;
                        typeCode = channel.get();
                    }
                    version = LogEntryVersion.byVersion(versionCode, this.logHeaderFormatVersion);
                    entryReader = version.entryParser(typeCode);
                    commandReader = this.commandReader(version);
                }
                catch (ReadPastEndException e) {
                    throw e;
                }
                catch (Exception e) {
                    LogPosition position = this.positionMarker.newPosition();
                    e = Exceptions.withMessage(e, e.getMessage() + ". At position " + position + " and entry version " + (Object)((Object)version));
                    throw Exceptions.launderedException(IOException.class, (Throwable)e);
                }
                entry = entryReader.parse(version, (ReadableLogChannel)channel, this.positionMarker, commandReader);
            } while (entryReader.skip());
            return entry;
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    private CommandReader commandReader(LogEntryVersion version) {
        if (version != this.lastVersion) {
            this.lastVersion = version;
            this.currentCommandReader = version.newCommandReader();
        }
        return this.currentCommandReader;
    }
}

