/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;

public class LogEntryCursor
implements IOCursor<LogEntry> {
    private final LogEntryReader<ReadableVersionableLogChannel> logEntryReader;
    private final ReadableVersionableLogChannel channel;
    private LogEntry entry;

    public LogEntryCursor(ReadableVersionableLogChannel channel) {
        this(new VersionAwareLogEntryReader<ReadableVersionableLogChannel>(), channel);
    }

    public LogEntryCursor(LogEntryReader<ReadableVersionableLogChannel> logEntryReader, ReadableVersionableLogChannel channel) {
        this.logEntryReader = logEntryReader;
        this.channel = channel;
    }

    @Override
    public LogEntry get() {
        return this.entry;
    }

    @Override
    public boolean next() throws IOException {
        this.entry = this.logEntryReader.readLogEntry(this.channel);
        return this.entry != null;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

