/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.function.Consumer;
import org.neo4j.function.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.store.kvstore.ActiveState;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveState;
import org.neo4j.kernel.impl.store.kvstore.ReadableState;
import org.neo4j.kernel.impl.store.kvstore.RotationState;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;
import org.neo4j.kernel.impl.store.kvstore.RotationTimerFactory;
import org.neo4j.kernel.impl.store.kvstore.ValueSink;
import org.neo4j.kernel.impl.store.kvstore.WritableState;
import org.neo4j.kernel.impl.util.function.Optional;
import org.neo4j.kernel.impl.util.function.Optionals;

abstract class DeadState<Key>
extends ProgressiveState<Key> {
    private final KeyFormat<Key> keys;
    final ActiveState.Factory stateFactory;

    @Override
    protected Headers headers() {
        throw new IllegalStateException("Cannot read in state: " + this.stateName());
    }

    @Override
    protected boolean lookup(Key key, ValueSink sink) throws IOException {
        throw new IllegalStateException("Cannot read in state: " + this.stateName());
    }

    @Override
    protected DataProvider dataProvider() throws IOException {
        throw new IllegalStateException("Cannot read in state: " + this.stateName());
    }

    @Override
    protected int storedEntryCount() {
        throw new IllegalStateException("Cannot read in state: " + this.stateName());
    }

    @Override
    protected Optional<EntryUpdater<Key>> optionalUpdater(long version, Lock lock) {
        throw new IllegalStateException("Cannot write in state: " + this.stateName());
    }

    @Override
    protected EntryUpdater<Key> unsafeUpdater(Lock lock) {
        throw new IllegalStateException("Cannot write in state: " + this.stateName());
    }

    @Override
    protected boolean hasChanges() {
        return false;
    }

    @Override
    void close() throws IOException {
        throw new IllegalStateException("Cannot close() in state: " + this.stateName());
    }

    @Override
    protected File file() {
        throw new IllegalStateException("No file assigned in state: " + this.stateName());
    }

    @Override
    protected long version() {
        return this.keys.version(null);
    }

    @Override
    protected KeyFormat<Key> keyFormat() {
        return this.keys;
    }

    private DeadState(KeyFormat<Key> keys, ActiveState.Factory stateFactory) {
        this.keys = keys;
        this.stateFactory = stateFactory;
    }

    private static abstract class Rotation<Key, State extends ProgressiveState<Key>>
    extends RotationState<Key> {
        final State state;

        Rotation(State state) {
            this.state = state;
        }

        @Override
        protected File file() {
            return ((ProgressiveState)this.state).file();
        }

        @Override
        Optional<EntryUpdater<Key>> optionalUpdater(long version, Lock lock) {
            throw new IllegalStateException("Cannot write in state: " + this.stateName());
        }

        @Override
        protected EntryUpdater<Key> unsafeUpdater(Lock lock) {
            throw new IllegalStateException("Cannot write in state: " + this.stateName());
        }

        @Override
        protected boolean hasChanges() {
            return ((WritableState)this.state).hasChanges();
        }

        @Override
        protected KeyFormat<Key> keyFormat() {
            return ((ReadableState)this.state).keyFormat();
        }

        @Override
        protected Headers headers() {
            return ((ReadableState)this.state).headers();
        }

        @Override
        protected long version() {
            return ((ReadableState)this.state).version();
        }

        @Override
        protected boolean lookup(Key key, ValueSink sink) throws IOException {
            throw new IllegalStateException("Cannot read in state: " + this.stateName());
        }

        @Override
        protected DataProvider dataProvider() throws IOException {
            throw new IllegalStateException("Cannot read in state: " + this.stateName());
        }

        @Override
        protected int storedEntryCount() {
            throw new IllegalStateException("Cannot read in state: " + this.stateName());
        }
    }

    private static class Prepared<Key>
    extends DeadState<Key> {
        private final ActiveState<Key> state;

        private Prepared(ActiveState<Key> state) {
            super(state.keyFormat(), state.factory());
            this.state = state;
        }

        @Override
        protected Headers headers() {
            return this.state.headers();
        }

        @Override
        protected Optional<EntryUpdater<Key>> optionalUpdater(long version, Lock lock) {
            if (version <= this.state.version()) {
                return Optionals.none();
            }
            return Optionals.some(this.state.updater(version, lock));
        }

        @Override
        RotationState<Key> prepareRotation(long version) {
            return new Rotation<Key, RotationState.Rotation<Key>>((RotationState.Rotation)this.state.prepareRotation(version)){

                @Override
                ProgressiveState<Key> rotate(boolean force, RotationStrategy strategy, RotationTimerFactory timerFactory, Consumer<Headers.Builder> headers) throws IOException {
                    return new Prepared((ActiveState)((RotationState.Rotation)this.state).rotate(force, strategy, timerFactory, (Consumer)headers));
                }

                @Override
                void close() throws IOException {
                    ((RotationState.Rotation)this.state).close();
                }

                @Override
                long rotationVersion() {
                    return ((RotationState.Rotation)this.state).rotationVersion();
                }
            };
        }

        @Override
        ProgressiveState<Key> stop() throws IOException {
            return this.state.stop();
        }

        @Override
        String stateName() {
            return "prepared";
        }

        @Override
        ActiveState<Key> start(DataInitializer<EntryUpdater<Key>> stateInitializer) {
            return this.state;
        }

        @Override
        protected File file() {
            return this.state.file();
        }
    }

    private static class NeedsCreation<Key>
    extends DeadState<Key>
    implements Function<ActiveState<Key>, NeedsCreation<Key>> {
        private final RotationStrategy rotation;

        private NeedsCreation(KeyFormat<Key> keys, ActiveState.Factory stateFactory, RotationStrategy rotation) {
            super(keys, stateFactory);
            this.rotation = rotation;
        }

        @Override
        ProgressiveState<Key> stop() throws IOException {
            return new Stopped(this.keyFormat(), this.stateFactory);
        }

        @Override
        String stateName() {
            return "needs creation";
        }

        @Override
        ActiveState<Key> start(DataInitializer<EntryUpdater<Key>> initializer) throws IOException {
            if (initializer == null) {
                throw new IllegalStateException("Store needs to be created, and no initializer is given.");
            }
            Pair<File, KeyValueStoreFile> created = this.initialState(initializer);
            return this.stateFactory.open(ReadableState.store(this.keyFormat(), created.other()), created.first());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Pair<File, KeyValueStoreFile> initialState(DataInitializer<EntryUpdater<Key>> initializer) throws IOException {
            long version = initializer.initialVersion();
            try (ActiveState creation = this.stateFactory.open(ReadableState.empty(this.keyFormat(), version), null);){
                try (EntryUpdater updater = creation.resetter(new ReentrantLock(), new Runnable(){

                    @Override
                    public void run() {
                    }
                });){
                    initializer.initialize(updater);
                }
                Pair<File, KeyValueStoreFile> pair = this.rotation.create(this.keyFormat().filter(creation.dataProvider()), initializer.initialVersion());
                return pair;
            }
        }

        @Override
        protected Optional<EntryUpdater<Key>> optionalUpdater(long version, Lock lock) {
            return Optionals.none();
        }

        @Override
        RotationState<Key> prepareRotation(long version) {
            return new Rotation<Key, NeedsCreation<Key>>(this){

                @Override
                ProgressiveState<Key> rotate(boolean force, RotationStrategy strategy, RotationTimerFactory timerFactory, Consumer<Headers.Builder> headers) throws IOException {
                    return this.state;
                }

                @Override
                void close() throws IOException {
                }

                @Override
                long rotationVersion() {
                    return ((NeedsCreation)this.state).version();
                }
            };
        }

        public NeedsCreation<Key> apply(ActiveState<Key> keyActiveState) throws RuntimeException {
            return this;
        }
    }

    static class Stopped<Key>
    extends DeadState<Key> {
        Stopped(KeyFormat<Key> keys, ActiveState.Factory stateFactory) {
            super(keys, stateFactory);
        }

        @Override
        String stateName() {
            return "stopped";
        }

        @Override
        ProgressiveState<Key> initialize(RotationStrategy rotation) throws IOException {
            Pair<File, KeyValueStoreFile> opened = rotation.open();
            if (opened == null) {
                return new NeedsCreation(this.keyFormat(), this.stateFactory, rotation);
            }
            return new Prepared(this.stateFactory.open(ReadableState.store(this.keyFormat(), opened.other()), opened.first()));
        }

        @Override
        ProgressiveState<Key> stop() throws IOException {
            return this;
        }
    }
}

