/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.ReadableTxState;
import org.neo4j.kernel.impl.api.RelationshipDataExtractor;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.RelationshipState;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;

public class TxStateTransactionDataSnapshot
implements TransactionData {
    private final ReadableTxState state;
    private final NodeProxy.NodeActions nodeActions;
    private final RelationshipProxy.RelationshipActions relationshipActions;
    private final StoreReadLayer store;
    private final RelationshipDataExtractor relationshipData = new RelationshipDataExtractor();
    private final Collection<PropertyEntry<Node>> assignedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> assignedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> assignedLabels = new ArrayList<LabelEntry>();
    private final Collection<PropertyEntry<Node>> removedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> removedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> removedLabels = new ArrayList<LabelEntry>();
    private final PrimitiveLongObjectMap<RelationshipProxy> relationshipsReadFromStore = Primitive.longObjectMap((int)16);

    public TxStateTransactionDataSnapshot(ReadableTxState state, NodeProxy.NodeActions nodeActions, RelationshipProxy.RelationshipActions relationshipActions, StoreReadLayer storeReadLayer) {
        this.state = state;
        this.nodeActions = nodeActions;
        this.relationshipActions = relationshipActions;
        this.store = storeReadLayer;
        this.takeSnapshot();
    }

    @Override
    public Iterable<Node> createdNodes() {
        return this.map2Nodes(this.state.addedAndRemovedNodes().getAdded());
    }

    @Override
    public Iterable<Node> deletedNodes() {
        return this.map2Nodes(this.state.addedAndRemovedNodes().getRemoved());
    }

    @Override
    public Iterable<Relationship> createdRelationships() {
        return this.map2Rels(this.state.addedAndRemovedRelationships().getAdded());
    }

    @Override
    public Iterable<Relationship> deletedRelationships() {
        return this.map2Rels(this.state.addedAndRemovedRelationships().getRemoved());
    }

    @Override
    public boolean isDeleted(Node node) {
        return this.state.nodeIsDeletedInThisTx(node.getId());
    }

    @Override
    public boolean isDeleted(Relationship relationship) {
        return this.state.relationshipIsDeletedInThisTx(relationship.getId());
    }

    @Override
    public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
        return this.assignedNodeProperties;
    }

    @Override
    public Iterable<PropertyEntry<Node>> removedNodeProperties() {
        return this.removedNodeProperties;
    }

    @Override
    public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
        return this.assignedRelationshipProperties;
    }

    @Override
    public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
        return this.removedRelationshipProperties;
    }

    @Override
    public Iterable<LabelEntry> removedLabels() {
        return this.removedLabels;
    }

    @Override
    public Iterable<LabelEntry> assignedLabels() {
        return this.assignedLabels;
    }

    private void takeSnapshot() {
        try {
            Object property;
            Relationship relationship;
            for (Long nodeId : this.state.addedAndRemovedNodes().getRemoved()) {
                Iterator<DefinedProperty> props = this.store.nodeGetAllProperties(nodeId);
                while (props.hasNext()) {
                    DefinedProperty prop = props.next();
                    this.removedNodeProperties.add(new NodePropertyEntryView(nodeId, this.store.propertyKeyGetName(prop.propertyKeyId()), null, prop.value()));
                }
                PrimitiveIntIterator labels = this.store.nodeGetLabels(nodeId);
                while (labels.hasNext()) {
                    this.removedLabels.add(new LabelEntryView(nodeId, this.store.labelGetName(labels.next())));
                }
            }
            for (Long relId : this.state.addedAndRemovedRelationships().getRemoved()) {
                relationship = this.relationship(relId);
                Iterator<DefinedProperty> props = this.store.relationshipGetAllProperties(relId);
                while (props.hasNext()) {
                    DefinedProperty prop = props.next();
                    this.removedRelationshipProperties.add(new RelationshipPropertyEntryView(relationship, this.store.propertyKeyGetName(prop.propertyKeyId()), null, prop.value()));
                }
            }
            for (NodeState nodeState : this.state.modifiedNodes()) {
                Iterator<DefinedProperty> added = nodeState.addedAndChangedProperties();
                while (added.hasNext()) {
                    DefinedProperty property2 = added.next();
                    this.assignedNodeProperties.add(new NodePropertyEntryView(nodeState.getId(), this.store.propertyKeyGetName(property2.propertyKeyId()), property2.value(), this.committedValue(this.store, nodeState, property2.propertyKeyId())));
                }
                Iterator<Integer> removed = nodeState.removedProperties();
                while (removed.hasNext()) {
                    property = removed.next();
                    this.removedNodeProperties.add(new NodePropertyEntryView(nodeState.getId(), this.store.propertyKeyGetName((Integer)property), null, this.committedValue(this.store, nodeState, ((Integer)property).intValue())));
                }
                ReadableDiffSets<Integer> labels = nodeState.labelDiffSets();
                for (Integer label : labels.getAdded()) {
                    this.assignedLabels.add(new LabelEntryView(nodeState.getId(), this.store.labelGetName(label)));
                }
                for (Integer label : labels.getRemoved()) {
                    this.removedLabels.add(new LabelEntryView(nodeState.getId(), this.store.labelGetName(label)));
                }
            }
            for (RelationshipState relState : this.state.modifiedRelationships()) {
                relationship = this.relationship(relState.getId());
                Iterator<DefinedProperty> added = relState.addedAndChangedProperties();
                while (added.hasNext()) {
                    property = added.next();
                    this.assignedRelationshipProperties.add(new RelationshipPropertyEntryView(relationship, this.store.propertyKeyGetName(((Property)property).propertyKeyId()), ((DefinedProperty)property).value(), this.committedValue(this.store, relState, ((Property)property).propertyKeyId())));
                }
                Iterator<Integer> removed = relState.removedProperties();
                while (removed.hasNext()) {
                    Integer property3 = removed.next();
                    this.removedRelationshipProperties.add(new RelationshipPropertyEntryView(relationship, this.store.propertyKeyGetName(property3), null, this.committedValue(this.store, relState, (int)property3)));
                }
            }
        }
        catch (EntityNotFoundException | LabelNotFoundKernelException | PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "An entity that does not exist was modified.", e);
        }
    }

    private Relationship relationship(long relId) {
        RelationshipProxy relationship = new RelationshipProxy(this.relationshipActions, relId);
        if (!this.state.relationshipVisit(relId, relationship)) {
            RelationshipProxy cached = (RelationshipProxy)this.relationshipsReadFromStore.get(relId);
            if (cached != null) {
                return relationship;
            }
            try {
                this.store.relationshipVisit(relId, relationship);
                this.relationshipsReadFromStore.put(relId, (Object)relationship);
            }
            catch (EntityNotFoundException e) {
                throw new ThisShouldNotHappenError("Mattias", "Getting deleted relationship data should have been covered by the tx state");
            }
        }
        return relationship;
    }

    private Iterable<Node> map2Nodes(Iterable<Long> added) {
        return new IterableWrapper<Node, Long>(added){

            @Override
            protected Node underlyingObjectToObject(Long id) {
                return new NodeProxy(TxStateTransactionDataSnapshot.this.nodeActions, id);
            }
        };
    }

    private Iterable<Relationship> map2Rels(Iterable<Long> ids) {
        return new IterableWrapper<Relationship, Long>(ids){

            @Override
            protected Relationship underlyingObjectToObject(Long id) {
                return TxStateTransactionDataSnapshot.this.relationship(id);
            }
        };
    }

    private Object committedValue(StoreReadLayer storeReadLayer, NodeState nodeState, int property) {
        try {
            if (this.state.nodeIsAddedInThisTx(nodeState.getId())) {
                return null;
            }
            return storeReadLayer.nodeGetProperty(nodeState.getId(), property).value();
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            return null;
        }
    }

    private Object committedValue(StoreReadLayer storeReadLayer, RelationshipState relState, int property) {
        try {
            if (this.state.relationshipIsAddedInThisTx(relState.getId())) {
                return null;
            }
            return storeReadLayer.relationshipGetProperty(relState.getId(), property).value();
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            return null;
        }
    }

    private class LabelEntryView
    implements LabelEntry {
        private final long nodeId;
        private final Label label;

        public LabelEntryView(long nodeId, String labelName) {
            this.nodeId = nodeId;
            this.label = DynamicLabel.label(labelName);
        }

        @Override
        public Label label() {
            return this.label;
        }

        @Override
        public Node node() {
            return new NodeProxy(TxStateTransactionDataSnapshot.this.nodeActions, this.nodeId);
        }

        public String toString() {
            return "LabelEntryView{nodeId=" + this.nodeId + ", label=" + this.label + '}';
        }
    }

    private class RelationshipPropertyEntryView
    implements PropertyEntry<Relationship> {
        private final Relationship relationship;
        private final String key;
        private final Object newValue;
        private final Object oldValue;

        public RelationshipPropertyEntryView(Relationship relationship, String key, Object newValue, Object oldValue) {
            this.relationship = relationship;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        @Override
        public Relationship entity() {
            return this.relationship;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Object previouslyCommitedValue() {
            return this.oldValue;
        }

        @Override
        public Object value() {
            if (this.newValue == null) {
                throw new IllegalStateException("This property has been removed, it has no value anymore.");
            }
            return this.newValue;
        }

        public String toString() {
            return "RelationshipPropertyEntryView{relId=" + this.relationship.getId() + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }

    private class NodePropertyEntryView
    implements PropertyEntry<Node> {
        private final long nodeId;
        private final String key;
        private final Object newValue;
        private final Object oldValue;

        public NodePropertyEntryView(long nodeId, String key, Object newValue, Object oldValue) {
            this.nodeId = nodeId;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        @Override
        public Node entity() {
            return new NodeProxy(TxStateTransactionDataSnapshot.this.nodeActions, this.nodeId);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Object previouslyCommitedValue() {
            return this.oldValue;
        }

        @Override
        public Object value() {
            if (this.newValue == null) {
                throw new IllegalStateException("This property has been removed, it has no value anymore.");
            }
            return this.newValue;
        }

        public String toString() {
            return "NodePropertyEntryView{nodeId=" + this.nodeId + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }
}

