/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobQueue;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJobFactory;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class IndexSamplingControllerFactory {
    private final IndexSamplingConfig config;
    private final IndexStoreView storeView;
    private final JobScheduler scheduler;
    private final TokenNameLookup tokenNameLookup;
    private final Logging logging;

    public IndexSamplingControllerFactory(IndexSamplingConfig config, IndexStoreView storeView, JobScheduler scheduler, TokenNameLookup tokenNameLookup, Logging logging) {
        this.config = config;
        this.storeView = storeView;
        this.scheduler = scheduler;
        this.tokenNameLookup = tokenNameLookup;
        this.logging = logging;
    }

    public IndexSamplingController create(IndexMapSnapshotProvider snapshotProvider) {
        OnlineIndexSamplingJobFactory jobFactory = new OnlineIndexSamplingJobFactory(this.storeView, this.tokenNameLookup, this.logging);
        Predicate<IndexDescriptor> samplingUpdatePredicate = this.createSamplingPredicate();
        IndexSamplingJobQueue<IndexDescriptor> jobQueue = new IndexSamplingJobQueue<IndexDescriptor>(samplingUpdatePredicate);
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, this.scheduler);
        Predicate<IndexDescriptor> indexRecoveryCondition = this.createIndexRecoveryCondition(this.logging, this.tokenNameLookup);
        return new IndexSamplingController(this.config, jobFactory, jobQueue, jobTracker, snapshotProvider, this.scheduler, indexRecoveryCondition);
    }

    private Predicate<IndexDescriptor> createSamplingPredicate() {
        return new Predicate<IndexDescriptor>(){
            private final Register.DoubleLongRegister output = Registers.newDoubleLongRegister();

            @Override
            public boolean accept(IndexDescriptor descriptor) {
                IndexSamplingControllerFactory.this.storeView.indexUpdatesAndSize(descriptor, this.output);
                long updates = this.output.readFirst();
                long size = this.output.readSecond();
                long threshold = Math.round(IndexSamplingControllerFactory.this.config.updateRatio() * (double)size);
                return updates > threshold;
            }
        };
    }

    private Predicate<IndexDescriptor> createIndexRecoveryCondition(final Logging logging, final TokenNameLookup tokenNameLookup) {
        return new Predicate<IndexDescriptor>(){
            private final StringLogger logger;
            private final Register.DoubleLongRegister register;
            {
                this.logger = logging.getMessagesLog(IndexSamplingController.class);
                this.register = Registers.newDoubleLongRegister();
            }

            @Override
            public boolean accept(IndexDescriptor descriptor) {
                boolean result;
                boolean bl = result = IndexSamplingControllerFactory.this.storeView.indexSample(descriptor, this.register).readSecond() == 0L;
                if (result) {
                    this.logger.warn("Recovering index sampling for index " + descriptor.userDescription(tokenNameLookup));
                }
                return result;
            }
        };
    }
}

