/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.RecoveryLabelScanWriterProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.RecoveryLegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

public class BatchingTransactionRepresentationStoreApplier
extends TransactionRepresentationStoreApplier {
    private final RecoveryLabelScanWriterProvider labelScanWriterProvider;
    private final RecoveryLegacyIndexApplierLookup legacyIndexApplierLookup;

    public BatchingTransactionRepresentationStoreApplier(IndexingService indexingService, LabelScanStore labelScanStore, NeoStore neoStore, CacheAccessBackDoor cacheAccess, LockService lockService, LegacyIndexApplierLookup legacyIndexProviderLookup, IndexConfigStore indexConfigStore, KernelHealth kernelHealth, IdOrderingQueue legacyIndexTransactionOrdering) {
        this(indexingService, new RecoveryLabelScanWriterProvider(labelScanStore, 1000), neoStore, cacheAccess, lockService, new RecoveryLegacyIndexApplierLookup(legacyIndexProviderLookup, 1000), indexConfigStore, kernelHealth, legacyIndexTransactionOrdering);
    }

    private BatchingTransactionRepresentationStoreApplier(IndexingService indexingService, RecoveryLabelScanWriterProvider labelScanWriterProvider, NeoStore neoStore, CacheAccessBackDoor cacheAccess, LockService lockService, RecoveryLegacyIndexApplierLookup legacyIndexApplierLookup, IndexConfigStore indexConfigStore, KernelHealth kernelHealth, IdOrderingQueue legacyIndexTransactionOrdering) {
        super(indexingService, labelScanWriterProvider, neoStore, cacheAccess, lockService, legacyIndexApplierLookup, indexConfigStore, kernelHealth, legacyIndexTransactionOrdering);
        this.labelScanWriterProvider = labelScanWriterProvider;
        this.legacyIndexApplierLookup = legacyIndexApplierLookup;
    }

    public void closeBatch() throws IOException {
        try {
            this.labelScanWriterProvider.close();
            this.legacyIndexApplierLookup.close();
            this.indexingService.flushAll();
        }
        catch (Throwable ex) {
            this.health.panic(ex);
            throw ex;
        }
    }
}

