/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityReader;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class InputRelationshipReader
extends InputEntityReader<InputRelationship> {
    private String previousType;

    public InputRelationshipReader(StoreChannel channel, StoreChannel header, int bufferSize) throws IOException {
        super(channel, header, bufferSize, 2);
    }

    @Override
    protected InputRelationship readNextOrNull(Object properties) throws IOException {
        Object type;
        long specificId = this.channel.get() == 1 ? this.channel.getLong() : -1L;
        Group startNodeGroup = this.readGroup(0);
        Group endNodeGroup = this.readGroup(1);
        Object startNodeId = this.readValue();
        Object endNodeId = this.readValue();
        byte typeMode = this.channel.get();
        switch (typeMode) {
            case 0: {
                type = this.previousType;
                break;
            }
            case 1: {
                this.previousType = this.readToken();
                type = this.previousType;
                break;
            }
            case 2: {
                type = this.channel.getInt();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized type mode " + typeMode);
            }
        }
        InputRelationship relationship = new InputRelationship(this.sourceDescription(), this.lineNumber(), this.position(), properties.getClass().isArray() ? (Object[])properties : InputEntity.NO_PROPERTIES, properties.getClass().isArray() ? null : (Long)properties, startNodeGroup, startNodeId, endNodeGroup, endNodeId, type instanceof String ? (String)type : null, type instanceof String ? null : (Integer)type);
        return specificId != -1L ? relationship.setSpecificId(specificId) : relationship;
    }
}

