/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping;

import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringEncoder;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Group;

public class IdMappers {
    public static IdMapper actual() {
        return new ActualIdMapper();
    }

    public static IdMapper strings(NumberArrayFactory cacheFactory) {
        return new EncodingIdMapper(cacheFactory, new StringEncoder(), Radix.STRING, EncodingIdMapper.NO_MONITOR);
    }

    public static IdMapper longs(NumberArrayFactory cacheFactory) {
        return new EncodingIdMapper(cacheFactory, new LongEncoder(), Radix.LONG, EncodingIdMapper.NO_MONITOR);
    }

    private static class ActualIdMapper
    implements IdMapper {
        private ActualIdMapper() {
        }

        @Override
        public void put(Object inputId, long actualId, Group group) {
        }

        @Override
        public boolean needsPreparation() {
            return false;
        }

        @Override
        public void prepare(InputIterable<Object> nodeData, Collector collector, ProgressListener progress) {
        }

        @Override
        public long get(Object inputId, Group group) {
            return (Long)inputId;
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

