/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class ParallelizeByNodeIdStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private static final int MAX_PARALLELIZABLE_BATCHES = 10;
    private final int idBatchSize;
    private long firstRecordId;
    private final long[] concurrentNodeIds;
    private int concurrentBatches;

    public ParallelizeByNodeIdStep(StageControl control, Configuration config) {
        super(control, "PARALLELIZE", config, 1, new StatsProvider[0]);
        this.idBatchSize = config.batchSize() * 2;
        this.concurrentNodeIds = new long[this.idBatchSize * 10];
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) throws Throwable {
        int concurrentNodeIdsRange = this.concurrentBatches * this.idBatchSize;
        batch.parallelizableWithPrevious = this.concurrentBatches < 10 && !Utils.anyIdCollides(this.concurrentNodeIds, concurrentNodeIdsRange, batch.sortedIds, batch.ids.length);
        batch.firstRecordId = this.firstRecordId;
        sender.send(batch);
        this.firstRecordId += (long)((InputRelationship[])batch.input).length;
        if (batch.parallelizableWithPrevious) {
            Utils.mergeSortedInto(batch.sortedIds, this.concurrentNodeIds, concurrentNodeIdsRange);
            ++this.concurrentBatches;
        } else {
            System.arraycopy(batch.sortedIds, 0, this.concurrentNodeIds, 0, batch.sortedIds.length);
            this.concurrentBatches = 1;
        }
    }
}

