/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.LegacyIndexProxy;

public class RelationshipLegacyIndexProxy
extends LegacyIndexProxy<Relationship>
implements RelationshipIndex {
    public RelationshipLegacyIndexProxy(String name, LegacyIndexProxy.Lookup lookup, ThreadToStatementContextBridge statementContextBridge) {
        super(name, LegacyIndexProxy.Type.RELATIONSHIP, lookup, statementContextBridge);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
        try (Statement statement = this.statementContextBridge.instance();){
            IndexHits<Relationship> indexHits = this.wrapIndexHits(statement.readOperations().relationshipLegacyIndexGet(this.name, key, valueOrNull, this.entityId(startNodeOrNull), this.entityId(endNodeOrNull)));
            return indexHits;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
        try (Statement statement = this.statementContextBridge.instance();){
            IndexHits<Relationship> indexHits = this.wrapIndexHits(statement.readOperations().relationshipLegacyIndexQuery(this.name, key, queryOrQueryObjectOrNull, this.entityId(startNodeOrNull), this.entityId(endNodeOrNull)));
            return indexHits;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
        try (Statement statement = this.statementContextBridge.instance();){
            IndexHits<Relationship> indexHits = this.wrapIndexHits(statement.readOperations().relationshipLegacyIndexQuery(this.name, queryOrQueryObjectOrNull, this.entityId(startNodeOrNull), this.entityId(endNodeOrNull)));
            return indexHits;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    private long entityId(Node nodeOrNull) {
        return nodeOrNull == null ? -1L : nodeOrNull.getId();
    }
}

