/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

public class RecoveryLegacyIndexApplierLookup
implements LegacyIndexApplierLookup,
Closeable {
    private final LegacyIndexApplierLookup lookup;
    private final Map<String, RecoveryCommandHandler> appliers = new HashMap<String, RecoveryCommandHandler>();
    private final int batchSize;

    public RecoveryLegacyIndexApplierLookup(LegacyIndexApplierLookup lookup, int batchSize) {
        this.lookup = lookup;
        this.batchSize = batchSize;
    }

    @Override
    public NeoCommandHandler newApplier(String name, boolean recovery) {
        RecoveryCommandHandler applier = this.appliers.get(name);
        if (applier == null) {
            NeoCommandHandler actualApplier = this.lookup.newApplier(name, recovery);
            applier = new RecoveryCommandHandler(name, actualApplier);
            this.appliers.put(name, applier);
        }
        return applier;
    }

    @Override
    public void close() throws IOException {
        Iterator<RecoveryCommandHandler> i$ = this.appliers.values().iterator();
        while (i$.hasNext()) {
            RecoveryCommandHandler applier;
            RecoveryCommandHandler closeThisPlease = applier = i$.next();
            Throwable throwable = null;
            try {
                applier.applyForReal();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closeThisPlease == null) continue;
                if (throwable != null) {
                    try {
                        closeThisPlease.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                closeThisPlease.close();
            }
        }
    }

    private class RecoveryCommandHandler
    extends NeoCommandHandler.Delegator {
        private final String name;
        private int applyCount;
        private boolean applied;

        RecoveryCommandHandler(String name, NeoCommandHandler applier) {
            super(applier);
            this.name = name;
        }

        @Override
        public void apply() {
            assert (!this.applied);
            if (++this.applyCount % RecoveryLegacyIndexApplierLookup.this.batchSize == 0) {
                this.applyForReal();
            }
        }

        @Override
        public void close() {
            if (this.applied) {
                super.close();
            }
        }

        private void applyForReal() {
            super.apply();
            RecoveryLegacyIndexApplierLookup.this.appliers.remove(this.name);
            this.applied = true;
        }
    }
}

