/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.InputEntityCacherStep;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIteratorBatcherStep;
import org.neo4j.unsafe.impl.batchimport.LabelScanStorePopulationStep;
import org.neo4j.unsafe.impl.batchimport.NodeEncoderStep;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStore;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class NodeStage
extends Stage {
    public NodeStage(Configuration config, IoMonitor writeMonitor, BatchingPageCache.WriterFactory writerFactory, InputIterable<InputNode> nodes, IdMapper idMapper, IdGenerator idGenerator, BatchingNeoStore neoStore, InputCache inputCache, LabelScanStore labelScanStore, EntityStoreUpdaterStep.Monitor storeUpdateMonitor, StatsProvider memoryUsage) throws IOException {
        super("Nodes", config, 1);
        this.add(new InputIteratorBatcherStep<InputNode>(this.control(), config, nodes.iterator(), InputNode.class));
        if (!nodes.supportsMultiplePasses()) {
            this.add(new InputEntityCacherStep(this.control(), config, inputCache.cacheNodes()));
        }
        NodeStore nodeStore = neoStore.getNodeStore();
        PropertyStore propertyStore = neoStore.getPropertyStore();
        this.add(new PropertyEncoderStep(this.control(), config, neoStore.getPropertyKeyRepository(), propertyStore));
        this.add(new NodeEncoderStep(this.control(), config, idMapper, idGenerator, neoStore.getLabelRepository(), nodeStore, memoryUsage));
        this.add(new LabelScanStorePopulationStep(this.control(), config, labelScanStore));
        this.add(new EntityStoreUpdaterStep(this.control(), config, nodeStore, propertyStore, writeMonitor, writerFactory, storeUpdateMonitor));
    }
}

