/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.monitoring.MonitorListenerInvocationHandler;

public class Monitors {
    private final Map<Method, List<MonitorListenerInvocationHandler>> methodMonitorListeners = new ConcurrentHashMap<Method, List<MonitorListenerInvocationHandler>>();
    private final List<Class<?>> monitoredInterfaces = new ArrayList();
    private final Map<Predicate<Method>, MonitorListenerInvocationHandler> monitorListeners = new ConcurrentHashMap<Predicate<Method>, MonitorListenerInvocationHandler>();
    private final Monitor monitorsMonitor = this.newMonitor(Monitor.class, new String[0]);

    public synchronized <T> T newMonitor(Class<T> monitorClass, Class<?> owningClass, String ... tags) {
        Iterable tagIer = Iterables.append(owningClass.getName(), Iterables.iterable(tags));
        String[] tagArray = Iterables.toArray(String.class, tagIer);
        return this.newMonitor(monitorClass, tagArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> T newMonitor(Class<T> monitorClass, String ... tags) {
        if (!this.monitoredInterfaces.contains(monitorClass)) {
            this.monitoredInterfaces.add(monitorClass);
            for (Method method : monitorClass.getMethods()) {
                this.recalculateMethodListeners(method);
            }
        }
        ClassLoader classLoader = monitorClass.getClassLoader();
        MonitorInvocationHandler monitorInvocationHandler = new MonitorInvocationHandler(tags);
        try {
            T t = monitorClass.cast(Proxy.newProxyInstance(classLoader, new Class[]{monitorClass}, (InvocationHandler)monitorInvocationHandler));
            return t;
        }
        finally {
            if (this.monitorsMonitor != null) {
                this.monitorsMonitor.monitorCreated(monitorClass, tags);
            }
        }
    }

    public synchronized void addMonitorListener(Object monitorListener, String ... tags) {
        UntaggedMonitorListenerInvocationHandler monitorListenerInvocationHandler = tags.length == 0 ? new UntaggedMonitorListenerInvocationHandler(monitorListener) : new TaggedMonitorListenerInvocationHandler(monitorListener, tags);
        for (Class<?> monitorInterface : this.getInterfacesOf(monitorListener.getClass())) {
            for (Method method : monitorInterface.getMethods()) {
                this.monitorListeners.put(Predicates.equalTo(method), monitorListenerInvocationHandler);
                this.recalculateMethodListeners(method);
            }
        }
    }

    public synchronized void removeMonitorListener(Object monitorListener) {
        Iterator<Map.Entry<Predicate<Method>, MonitorListenerInvocationHandler>> iter = this.monitorListeners.entrySet().iterator();
        while (iter.hasNext()) {
            UntaggedMonitorListenerInvocationHandler handler;
            Map.Entry<Predicate<Method>, MonitorListenerInvocationHandler> handlerEntry = iter.next();
            if (!(handlerEntry.getValue() instanceof UntaggedMonitorListenerInvocationHandler) || (handler = (UntaggedMonitorListenerInvocationHandler)handlerEntry.getValue()).getMonitorListener() != monitorListener) continue;
            iter.remove();
        }
        this.recalculateAllMethodListeners();
    }

    public synchronized void addMonitorListener(MonitorListenerInvocationHandler invocationHandler, Predicate<Method> methodSpecification) {
        this.monitorListeners.put(methodSpecification, invocationHandler);
        this.recalculateAllMethodListeners();
    }

    public synchronized void removeMonitorListener(MonitorListenerInvocationHandler invocationHandler) {
        Iterator<Map.Entry<Predicate<Method>, MonitorListenerInvocationHandler>> iter = this.monitorListeners.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Predicate<Method>, MonitorListenerInvocationHandler> handlerEntry = iter.next();
            if (handlerEntry.getValue() != invocationHandler) continue;
            iter.remove();
            this.recalculateAllMethodListeners();
            return;
        }
    }

    private void recalculateMethodListeners(Method method) {
        ArrayList<MonitorListenerInvocationHandler> listeners = new ArrayList<MonitorListenerInvocationHandler>();
        for (Map.Entry<Predicate<Method>, MonitorListenerInvocationHandler> handlerEntry : this.monitorListeners.entrySet()) {
            if (!handlerEntry.getKey().accept(method)) continue;
            listeners.add(handlerEntry.getValue());
        }
        this.methodMonitorListeners.put(method, listeners);
    }

    private void recalculateAllMethodListeners() {
        for (Method method : this.methodMonitorListeners.keySet()) {
            this.recalculateMethodListeners(method);
        }
    }

    private Iterable<Class<?>> getInterfacesOf(Class<?> aClass) {
        ArrayList interfaces = new ArrayList();
        while (aClass != null) {
            Collections.addAll(interfaces, aClass.getInterfaces());
            aClass = aClass.getSuperclass();
        }
        return interfaces;
    }

    private class MonitorInvocationHandler
    implements InvocationHandler {
        private String[] tags;

        public MonitorInvocationHandler(String ... tags) {
            this.tags = tags;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.invokeMonitorListeners(proxy, method, args);
            return null;
        }

        private void invokeMonitorListeners(Object proxy, Method method, Object[] args) {
            List handlers = (List)Monitors.this.methodMonitorListeners.get(method);
            if (handlers != null) {
                for (MonitorListenerInvocationHandler monitorListenerInvocationHandler : handlers) {
                    try {
                        monitorListenerInvocationHandler.invoke(proxy, method, args, this.tags);
                    }
                    catch (Throwable e) {
                        if (method.getDeclaringClass().equals(Monitor.class)) continue;
                        Monitors.this.monitorsMonitor.monitorListenerException(e);
                    }
                }
            }
        }
    }

    private static class TaggedMonitorListenerInvocationHandler
    extends UntaggedMonitorListenerInvocationHandler {
        private final String[] tags;

        public TaggedMonitorListenerInvocationHandler(Object monitorListener, String ... tags) {
            super(monitorListener);
            this.tags = tags;
        }

        @Override
        public void invoke(Object proxy, Method method, Object[] args, String ... tags) throws Throwable {
            block0: for (String requiredTag : this.tags) {
                for (String tag : tags) {
                    if (requiredTag.equals(tag)) continue block0;
                }
                return;
            }
            super.invoke(proxy, method, args, tags);
        }
    }

    private static class UntaggedMonitorListenerInvocationHandler
    implements MonitorListenerInvocationHandler {
        private final Object monitorListener;

        public UntaggedMonitorListenerInvocationHandler(Object monitorListener) {
            this.monitorListener = monitorListener;
        }

        public Object getMonitorListener() {
            return this.monitorListener;
        }

        @Override
        public void invoke(Object proxy, Method method, Object[] args, String ... tags) throws Throwable {
            method.invoke(this.monitorListener, args);
        }
    }

    public static interface Monitor {
        public void monitorCreated(Class<?> var1, String ... var2);

        public void monitorListenerException(Throwable var1);

        public static class Adapter
        implements Monitor {
            @Override
            public void monitorCreated(Class<?> monitorClass, String ... tags) {
            }

            @Override
            public void monitorListenerException(Throwable throwable) {
            }
        }
    }
}

