/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.util.ArrayMap;

public class PropertyDeleter {
    private final PropertyStore propertyStore;
    private final PropertyTraverser traverser;

    public PropertyDeleter(PropertyStore propertyStore, PropertyTraverser traverser) {
        this.propertyStore = propertyStore;
        this.traverser = traverser;
    }

    public ArrayMap<Integer, DefinedProperty> getAndDeletePropertyChain(PrimitiveRecord primitive, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        ArrayMap<Integer, DefinedProperty> result = new ArrayMap<Integer, DefinedProperty>(9, false, true);
        long nextProp = primitive.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> propertyChange = propertyRecords.getOrLoad(nextProp, primitive);
            PropertyRecord propRecord = propertyChange.forChangingData();
            PropertyRecord before = propertyChange.getBefore();
            for (PropertyBlock block : before) {
                result.put(block.getKeyIndexId(), block.newPropertyData(this.propertyStore));
            }
            for (PropertyBlock block : propRecord) {
                for (DynamicRecord valueRecord : block.getValueRecords()) {
                    assert (valueRecord.inUse());
                    valueRecord.setInUse(false);
                    propRecord.addDeletedRecord(valueRecord);
                }
            }
            nextProp = propRecord.getNextProp();
            propRecord.setInUse(false);
            propRecord.setChanged(primitive);
            propRecord.clearPropertyBlocks();
        }
        primitive.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
        return result;
    }

    public <P extends PrimitiveRecord> void removeProperty(RecordAccess.RecordProxy<Long, P, Void> primitiveProxy, int propertyKey, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveProxy.forReadingData();
        long propertyId = this.traverser.findPropertyRecordContaining(primitive, propertyKey, propertyRecords, true);
        RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> recordChange = propertyRecords.getOrLoad(propertyId, primitive);
        PropertyRecord propRecord = recordChange.forChangingData();
        if (!propRecord.inUse()) {
            throw new IllegalStateException("Unable to delete property[" + propertyId + "] since it is already deleted.");
        }
        PropertyBlock block = propRecord.removePropertyBlock(propertyKey);
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyKey + "] is not present in property[" + propertyId + "]");
        }
        for (DynamicRecord valueRecord : block.getValueRecords()) {
            assert (valueRecord.inUse());
            valueRecord.setInUse(false, block.getType().intValue());
            propRecord.addDeletedRecord(valueRecord);
        }
        if (propRecord.size() > 0) {
            propRecord.setChanged(primitive);
            assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        } else {
            this.unlinkPropertyRecord(propRecord, propertyRecords, primitiveProxy);
        }
    }

    private <P extends PrimitiveRecord> void unlinkPropertyRecord(PropertyRecord propRecord, RecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords, RecordAccess.RecordProxy<Long, P, Void> primitiveRecordChange) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        assert (propRecord.size() == 0);
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (primitive.getNextProp() == propRecord.getId()) {
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(nextProp);
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = propertyRecords.getOrLoad(prevProp, primitive).forChangingLinkage();
            assert (prevPropRecord.inUse()) : prevPropRecord + "->" + propRecord + " for " + primitive;
            prevPropRecord.setNextProp(nextProp);
            prevPropRecord.setChanged(primitive);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = propertyRecords.getOrLoad(nextProp, primitive).forChangingLinkage();
            assert (nextPropRecord.inUse()) : propRecord + "->" + nextPropRecord + " for " + primitive;
            nextPropRecord.setPrevProp(prevProp);
            nextPropRecord.setChanged(primitive);
        }
        propRecord.setInUse(false);
        propRecord.setPrevProp(Record.NO_PREVIOUS_PROPERTY.intValue());
        propRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
        propRecord.setChanged(primitive);
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
    }
}

