/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;

public enum LogEntryParsersV5 implements LogEntryParser<LogEntry>
{
    EMPTY{

        @Override
        public LogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            return null;
        }

        @Override
        public byte byteCode() {
            return 0;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    TX_START{

        @Override
        public LogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            LogPosition position = marker.newPosition();
            int masterId = channel.getInt();
            int authorId = channel.getInt();
            long timeWritten = channel.getLong();
            long latestCommittedTxWhenStarted = channel.getLong();
            int additionalHeaderLength = channel.getInt();
            byte[] additionalHeader = new byte[additionalHeaderLength];
            channel.get(additionalHeader, additionalHeaderLength);
            return new LogEntryStart(version, masterId, authorId, timeWritten, latestCommittedTxWhenStarted, additionalHeader, position);
        }

        @Override
        public byte byteCode() {
            return 1;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    COMMAND{

        @Override
        public LogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            CommandReader commandReader = commandReaderFactory.newInstance((byte)5, version);
            Command command = commandReader.read(channel);
            return command == null ? null : new LogEntryCommand(version, command);
        }

        @Override
        public byte byteCode() {
            return 3;
        }

        @Override
        public boolean skip() {
            return false;
        }
    }
    ,
    TX_1P_COMMIT{

        @Override
        public LogEntry parse(byte version, ReadableLogChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
            long txId = channel.getLong();
            long timeWritten = channel.getLong();
            return new OnePhaseCommit(version, txId, timeWritten);
        }

        @Override
        public byte byteCode() {
            return 5;
        }

        @Override
        public boolean skip() {
            return false;
        }
    };

}

