/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Lock;
import org.neo4j.function.Consumer;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.store.kvstore.ActiveState;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveState;
import org.neo4j.kernel.impl.store.kvstore.PrototypeState;
import org.neo4j.kernel.impl.store.kvstore.ReadableState;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;
import org.neo4j.kernel.impl.store.kvstore.ValueSink;
import org.neo4j.kernel.impl.store.kvstore.ValueUpdate;
import org.neo4j.kernel.impl.util.function.Optional;
import org.neo4j.kernel.impl.util.function.Optionals;

abstract class RotationState<Key>
extends ProgressiveState<Key> {
    RotationState() {
    }

    abstract ProgressiveState<Key> rotate(boolean var1, RotationStrategy var2, Consumer<Headers.Builder> var3) throws IOException;

    @Override
    String stateName() {
        return "rotating";
    }

    @Override
    abstract void close() throws IOException;

    abstract long rotationVersion();

    static final class Rotation<Key>
    extends RotationState<Key> {
        private final ActiveState<Key> preState;
        private final PrototypeState<Key> postState;
        private final long threshold;

        Rotation(ActiveState<Key> preState, PrototypeState<Key> postState, long version) {
            this.preState = preState;
            this.postState = postState;
            this.threshold = version;
        }

        @Override
        ActiveState<Key> rotate(boolean force, RotationStrategy strategy, Consumer<Headers.Builder> headersUpdater) throws IOException {
            if (!force) {
                long expected = this.threshold - this.preState.store.version();
                long sleep = 10L;
                while (this.preState.applied() < expected) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e) {
                        throw Exceptions.withCause(new InterruptedIOException("Rotation was interrupted."), e);
                    }
                    sleep = Math.min(sleep * 2L, 100L);
                }
            }
            Pair<File, KeyValueStoreFile> next = strategy.next(this.file(), this.updateHeaders(headersUpdater), this.keyFormat().filter(this.preState.dataProvider()));
            return this.postState.create(ReadableState.store(this.preState.keyFormat(), next.other()), next.first());
        }

        @Override
        void close() throws IOException {
            this.preState.close();
        }

        @Override
        long rotationVersion() {
            return this.threshold;
        }

        private Headers updateHeaders(Consumer<Headers.Builder> headersUpdater) {
            Headers.Builder builder = new Headers.Builder(Headers.copy(this.preState.headers()));
            headersUpdater.accept((Object)builder);
            return builder.headers();
        }

        @Override
        protected Optional<EntryUpdater<Key>> optionalUpdater(long version, Lock lock) {
            final EntryUpdater<Key> post = this.postState.updater(version, lock);
            if (version <= this.threshold) {
                final EntryUpdater<Key> pre = this.preState.updater(version, lock);
                return Optionals.some(new EntryUpdater<Key>(lock){

                    @Override
                    public void apply(Key key, ValueUpdate update) throws IOException {
                        post.apply(key, update);
                        pre.apply(key, update);
                    }

                    @Override
                    public void close() {
                        post.close();
                        pre.close();
                        super.close();
                    }
                });
            }
            return Optionals.some(post);
        }

        @Override
        protected File file() {
            return this.preState.file();
        }

        @Override
        protected long storedVersion() {
            return this.preState.storedVersion();
        }

        @Override
        protected KeyFormat<Key> keyFormat() {
            return this.preState.keyFormat();
        }

        @Override
        protected Headers headers() {
            return this.preState.headers();
        }

        @Override
        protected DataProvider dataProvider() throws IOException {
            return this.postState.dataProvider();
        }

        @Override
        protected int storedEntryCount() {
            return this.postState.storedEntryCount();
        }

        @Override
        protected EntryUpdater<Key> unsafeUpdater(Lock lock) {
            return this.postState.unsafeUpdater(lock);
        }

        @Override
        protected boolean hasChanges() {
            return this.preState.hasChanges() || this.postState.hasChanges();
        }

        @Override
        protected long version() {
            return this.postState.version();
        }

        @Override
        protected boolean lookup(Key key, ValueSink sink) throws IOException {
            return this.postState.lookup(key, sink);
        }
    }
}

