/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.AbstractStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.CappedOperation;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class NeoStore
extends AbstractStore
implements TransactionIdStore,
LogVersionRepository {
    public static final String TYPE_DESCRIPTOR = "NeoStore";
    public static final long FIELD_NOT_INITIALIZED = Long.MIN_VALUE;
    public static final int RECORD_SIZE = 9;
    public static final String DEFAULT_NAME = "neostore";
    public static final int META_DATA_RECORD_COUNT = Position.values().length;
    private NodeStore nodeStore;
    private PropertyStore propStore;
    private RelationshipStore relStore;
    private RelationshipTypeTokenStore relTypeStore;
    private LabelTokenStore labelTokenStore;
    private SchemaStore schemaStore;
    private RelationshipGroupStore relGroupStore;
    private CountsTracker counts;
    private volatile long creationTimeField = Long.MIN_VALUE;
    private volatile long randomNumberField = Long.MIN_VALUE;
    private volatile long versionField = Long.MIN_VALUE;
    private final AtomicLong lastCommittingTxField = new AtomicLong(Long.MIN_VALUE);
    private volatile long storeVersionField = Long.MIN_VALUE;
    private volatile long graphNextPropField = Long.MIN_VALUE;
    private volatile long latestConstraintIntroducingTxField = Long.MIN_VALUE;
    private volatile long upgradeTxIdField = Long.MIN_VALUE;
    private volatile long upgradeTimeField = Long.MIN_VALUE;
    private volatile long lastTransactionChecksum = Long.MIN_VALUE;
    private volatile long upgradeTxChecksumField = Long.MIN_VALUE;
    private final OutOfOrderSequence lastCommittedTx = new ArrayQueueOutOfOrderSequence(-1L, 200);
    private final OutOfOrderSequence lastClosedTx = new ArrayQueueOutOfOrderSequence(-1L, 200);
    private final int relGrabSize;
    private final CappedOperation<Void> transactionCloseWaitLogger;

    public static boolean isStorePresent(FileSystemAbstraction fs, Config config) {
        File neoStore = config.get(CommonAbstractStore.Configuration.neo_store);
        return fs.fileExists(neoStore);
    }

    public NeoStore(File fileName, Config conf, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, final StringLogger stringLogger, RelationshipTypeTokenStore relTypeStore, LabelTokenStore labelTokenStore, PropertyStore propStore, RelationshipStore relStore, NodeStore nodeStore, SchemaStore schemaStore, RelationshipGroupStore relGroupStore, CountsTracker counts, StoreVersionMismatchHandler versionMismatchHandler, Monitors monitors) {
        super(fileName, conf, IdType.NEOSTORE_BLOCK, idGeneratorFactory, pageCache, fileSystemAbstraction, stringLogger, versionMismatchHandler);
        this.relTypeStore = relTypeStore;
        this.labelTokenStore = labelTokenStore;
        this.propStore = propStore;
        this.relStore = relStore;
        this.nodeStore = nodeStore;
        this.schemaStore = schemaStore;
        this.relGroupStore = relGroupStore;
        this.counts = counts;
        this.relGrabSize = conf.get(Configuration.relationship_grab_size);
        this.transactionCloseWaitLogger = new CappedOperation<Void>(new CappedOperation.Switch[]{CappedOperation.time(30L, TimeUnit.SECONDS)}){

            @Override
            protected void triggered(Void event) {
                stringLogger.info(String.format("Waiting for all transactions to close...%n committed:  %s%n  committing: %s%n  closed:     %s", NeoStore.this.lastCommittedTx, NeoStore.this.lastCommittingTxField, NeoStore.this.lastClosedTx));
            }
        };
        counts.setInitializer(new DataInitializer<CountsAccessor.Updater>(){

            @Override
            public void initialize(CountsAccessor.Updater updater) {
                stringLogger.warn("Missing counts store, rebuilding it.");
                new CountsComputer(NeoStore.this).initialize(updater);
            }

            @Override
            public long initialVersion() {
                return NeoStore.this.getLastCommittedTransactionId();
            }
        });
        try {
            counts.init();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to initialize counts store", e);
        }
    }

    @Override
    protected void checkVersion() {
        try {
            String foundVersion;
            this.verifyCorrectTypeDescriptorAndVersion();
            if (!this.getStoreOk() && !"v0.A.5".equals(foundVersion = NeoStore.versionLongToString(NeoStore.getRecord(this.fileSystemAbstraction, (File)this.configuration.get(Configuration.neo_store), Position.STORE_VERSION)))) {
                throw new IllegalStateException(String.format("Mismatching store version found (%s while expecting %s). The store cannot be automatically upgraded since it isn't cleanly shutdown. Recover by starting the database using the previous Neo4j version, followed by a clean shutdown. Then start with this version again.", foundVersion, "v0.A.5"));
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to check version " + this.getStorageFileName(), e);
        }
    }

    @Override
    protected void closeStorage() {
        if (this.relTypeStore != null) {
            this.relTypeStore.close();
            this.relTypeStore = null;
        }
        if (this.labelTokenStore != null) {
            this.labelTokenStore.close();
            this.labelTokenStore = null;
        }
        if (this.propStore != null) {
            this.propStore.close();
            this.propStore = null;
        }
        if (this.relStore != null) {
            this.relStore.close();
            this.relStore = null;
        }
        if (this.nodeStore != null) {
            this.nodeStore.close();
            this.nodeStore = null;
        }
        if (this.schemaStore != null) {
            this.schemaStore.close();
            this.schemaStore = null;
        }
        if (this.relGroupStore != null) {
            this.relGroupStore.close();
            this.relGroupStore = null;
        }
        if (this.counts != null) {
            try {
                this.counts.rotate(this.getLastCommittedTransactionId());
                this.counts.shutdown();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
            finally {
                this.counts = null;
            }
        }
    }

    @Override
    public void flush() {
        try {
            if (this.counts != null) {
                this.counts.rotate(this.getLastCommittedTransactionId());
            }
            this.pageCache.flushAndForce();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush", e);
        }
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    public static long setRecord(FileSystemAbstraction fileSystem, File neoStore, Position position, long value) throws IOException {
        int trailerSize = UTF8.encode(NeoStore.buildTypeDescriptorAndVersion(TYPE_DESCRIPTOR)).length;
        try (StoreChannel channel = fileSystem.open(neoStore, "rw");){
            long previous = Long.MIN_VALUE;
            long trailerOffset = channel.size() - (long)trailerSize;
            ByteBuffer buffer = ByteBuffer.allocate(9);
            ByteBuffer trailerBuffer = null;
            int recordOffset = 9 * position.id;
            if ((long)recordOffset < trailerOffset) {
                channel.position((long)recordOffset);
                channel.read(buffer);
                buffer.flip();
                buffer.get();
                previous = buffer.getLong();
            } else {
                trailerBuffer = ByteBuffer.allocate(trailerSize);
                channel.position(trailerOffset);
                channel.read(trailerBuffer);
                trailerBuffer.flip();
                channel.truncate(trailerOffset);
            }
            buffer.clear();
            channel.position((long)recordOffset);
            buffer.put(Record.IN_USE.byteValue());
            buffer.putLong(value);
            buffer.flip();
            channel.write(buffer);
            int newTrailerOffset = recordOffset + 9;
            if ((long)newTrailerOffset > trailerOffset) {
                assert (trailerBuffer != null);
                channel.position((long)newTrailerOffset);
                channel.write(trailerBuffer);
            }
            long l = previous;
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getRecord(FileSystemAbstraction fs, File neoStore, Position recordPosition) {
        try (StoreChannel channel = fs.open(neoStore, "r");){
            if (recordPosition.id >= Position.STORE_VERSION.id && channel.size() < 45L) {
                long l = -1L;
                return l;
            }
            channel.position((long)(9 * recordPosition.id + 1));
            ByteBuffer buffer = ByteBuffer.allocate(8);
            channel.read(buffer);
            buffer.flip();
            long l = buffer.getLong();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StoreId getStoreId() {
        return new StoreId(this.getCreationTime(), this.getRandomNumber(), this.getUpgradeTime(), this.upgradeTxIdField);
    }

    public long getUpgradeTime() {
        this.checkInitialized(this.upgradeTimeField);
        return this.upgradeTimeField;
    }

    public synchronized void setUpgradeTime(long time) {
        this.setRecord(Position.UPGRADE_TIME, time);
        this.upgradeTimeField = time;
    }

    public synchronized void setUpgradeTransaction(long id, long checksum) {
        this.setRecord(Position.UPGRADE_TRANSACTION_ID, id);
        this.upgradeTxIdField = id;
        this.setRecord(Position.UPGRADE_TRANSACTION_CHECKSUM, checksum);
        this.upgradeTxChecksumField = checksum;
    }

    public long getCreationTime() {
        this.checkInitialized(this.creationTimeField);
        return this.creationTimeField;
    }

    public synchronized void setCreationTime(long time) {
        this.setRecord(Position.TIME, time);
        this.creationTimeField = time;
    }

    public long getRandomNumber() {
        this.checkInitialized(this.randomNumberField);
        return this.randomNumberField;
    }

    public synchronized void setRandomNumber(long nr) {
        this.setRecord(Position.RANDOM_NUMBER, nr);
        this.randomNumberField = nr;
    }

    @Override
    public long getCurrentLogVersion() {
        this.checkInitialized(this.versionField);
        return this.versionField;
    }

    public void setCurrentLogVersion(long version) {
        this.setRecord(Position.LOG_VERSION, version);
        this.versionField = version;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long incrementAndGetVersion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getStoreVersion() {
        this.checkInitialized(this.storeVersionField);
        return this.storeVersionField;
    }

    public void setStoreVersion(long version) {
        this.setRecord(Position.STORE_VERSION, version);
        this.storeVersionField = version;
    }

    public long getGraphNextProp() {
        this.checkInitialized(this.graphNextPropField);
        return this.graphNextPropField;
    }

    public void setGraphNextProp(long propId) {
        this.setRecord(Position.FIRST_GRAPH_PROPERTY, propId);
        this.graphNextPropField = propId;
    }

    public long getLatestConstraintIntroducingTx() {
        this.checkInitialized(this.latestConstraintIntroducingTxField);
        return this.latestConstraintIntroducingTxField;
    }

    public void setLatestConstraintIntroducingTx(long latestConstraintIntroducingTx) {
        this.setRecord(Position.LAST_CONSTRAINT_TRANSACTION, latestConstraintIntroducingTx);
        this.latestConstraintIntroducingTxField = latestConstraintIntroducingTx;
    }

    private void readAllFields(PageCursor cursor) throws IOException {
        do {
            this.creationTimeField = this.getRecordValue(cursor, Position.TIME);
            this.randomNumberField = this.getRecordValue(cursor, Position.RANDOM_NUMBER);
            this.versionField = this.getRecordValue(cursor, Position.LOG_VERSION);
            this.upgradeTxIdField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_ID);
            this.upgradeTimeField = this.getRecordValue(cursor, Position.UPGRADE_TIME);
            long lastCommittedTxId = this.getRecordValue(cursor, Position.LAST_TRANSACTION_ID);
            this.lastCommittingTxField.set(lastCommittedTxId);
            this.storeVersionField = this.getRecordValue(cursor, Position.STORE_VERSION);
            this.graphNextPropField = this.getRecordValue(cursor, Position.FIRST_GRAPH_PROPERTY);
            this.latestConstraintIntroducingTxField = this.getRecordValue(cursor, Position.LAST_CONSTRAINT_TRANSACTION);
            this.lastTransactionChecksum = this.getRecordValue(cursor, Position.LAST_TRANSACTION_CHECKSUM);
            this.lastClosedTx.set(lastCommittedTxId, 0L);
            this.lastCommittedTx.set(lastCommittedTxId, this.lastTransactionChecksum);
            this.upgradeTxChecksumField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_CHECKSUM);
        } while (cursor.shouldRetry());
    }

    private long getRecordValue(PageCursor cursor, Position position) {
        int offset = position.id * this.getEffectiveRecordSize() + 1;
        cursor.setOffset(offset);
        return cursor.getLong();
    }

    private void incrementVersion(PageCursor cursor) throws IOException {
        long value;
        int offset = Position.LOG_VERSION.id * this.getEffectiveRecordSize();
        do {
            cursor.setOffset(offset + 1);
            value = cursor.getLong() + 1L;
            cursor.setOffset(offset + 1);
            cursor.putLong(value);
        } while (cursor.shouldRetry());
        this.versionField = value;
    }

    private void refreshFields() {
        this.scanAllFields(1);
    }

    private void scanAllFields(int pf_flags) {
        try (PageCursor cursor = this.storeFile.io(0L, pf_flags);){
            if (cursor.next()) {
                this.readAllFields(cursor);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void setRecord(Position recordPosition, long value) {
        long id = recordPosition.id;
        long pageId = this.pageIdForRecord(id);
        this.setHighestPossibleIdInUse(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 2);){
            if (cursor.next()) {
                int offset = this.offsetForId(id);
                do {
                    cursor.setOffset(offset);
                    cursor.putByte(Record.IN_USE.byteValue());
                    cursor.putLong(value);
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    public SchemaStore getSchemaStore() {
        return this.schemaStore;
    }

    public RelationshipStore getRelationshipStore() {
        return this.relStore;
    }

    public RelationshipTypeTokenStore getRelationshipTypeTokenStore() {
        return this.relTypeStore;
    }

    public LabelTokenStore getLabelTokenStore() {
        return this.labelTokenStore;
    }

    public PropertyStore getPropertyStore() {
        return this.propStore;
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return this.propStore.getPropertyKeyTokenStore();
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return this.relGroupStore;
    }

    public CountsTracker getCounts() {
        return this.counts;
    }

    @Override
    public void makeStoreOk() {
        this.relTypeStore.makeStoreOk();
        this.labelTokenStore.makeStoreOk();
        this.propStore.makeStoreOk();
        this.relStore.makeStoreOk();
        this.nodeStore.makeStoreOk();
        this.schemaStore.makeStoreOk();
        this.relGroupStore.makeStoreOk();
        super.makeStoreOk();
    }

    public void rebuildIdGenerators() {
        this.relTypeStore.rebuildIdGenerator();
        this.labelTokenStore.rebuildIdGenerator();
        this.propStore.rebuildIdGenerator();
        this.relStore.rebuildIdGenerator();
        this.nodeStore.rebuildIdGenerator();
        this.schemaStore.rebuildIdGenerator();
        this.relGroupStore.rebuildIdGenerator();
        super.rebuildIdGenerator();
    }

    public int getRelationshipGrabSize() {
        return this.relGrabSize;
    }

    public void verifyStoreOk() {
        this.visitStore(new Visitor<CommonAbstractStore, RuntimeException>(){

            @Override
            public boolean visit(CommonAbstractStore element) {
                element.checkStoreOk();
                return false;
            }
        });
    }

    @Override
    public void logVersions(StringLogger.LineLogger msgLog) {
        msgLog.logLine("Store versions:");
        super.logVersions(msgLog);
        this.schemaStore.logVersions(msgLog);
        this.nodeStore.logVersions(msgLog);
        this.relStore.logVersions(msgLog);
        this.relTypeStore.logVersions(msgLog);
        this.labelTokenStore.logVersions(msgLog);
        this.propStore.logVersions(msgLog);
        this.relGroupStore.logVersions(msgLog);
        this.stringLogger.flush();
    }

    @Override
    public void logIdUsage(StringLogger.LineLogger msgLog) {
        msgLog.logLine("Id usage:");
        this.schemaStore.logIdUsage(msgLog);
        this.nodeStore.logIdUsage(msgLog);
        this.relStore.logIdUsage(msgLog);
        this.relTypeStore.logIdUsage(msgLog);
        this.labelTokenStore.logIdUsage(msgLog);
        this.propStore.logIdUsage(msgLog);
        this.relGroupStore.logIdUsage(msgLog);
        this.stringLogger.flush();
    }

    public NeoStoreRecord asRecord() {
        NeoStoreRecord result = new NeoStoreRecord();
        result.setNextProp(this.getGraphNextProp());
        return result;
    }

    public static long versionStringToLong(String storeVersion) {
        if ("Unknown".equals(storeVersion)) {
            return -1L;
        }
        Bits bits = Bits.bits(8);
        int length = storeVersion.length();
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The given string %s is not of proper size for a store version string", storeVersion));
        }
        bits.put(length, 8);
        for (int i = 0; i < length; ++i) {
            char c = storeVersion.charAt(i);
            if (c < '\u0000' || c >= '\u0100') {
                throw new IllegalArgumentException(String.format("Store version strings should be encode-able as Latin1 - %s is not", storeVersion));
            }
            bits.put(c, 8);
        }
        return bits.getLong();
    }

    public static String versionLongToString(long storeVersion) {
        if (storeVersion == -1L) {
            return "Unknown";
        }
        Bits bits = Bits.bitsFromLongs(new long[]{storeVersion});
        int length = bits.getShort(8);
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The read version string length %d is not proper.", length));
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    public int getDenseNodeThreshold() {
        return this.getRelationshipGroupStore().getDenseNodeThreshold();
    }

    @Override
    public long nextCommittingTransactionId() {
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastCommittingTxField.incrementAndGet();
    }

    @Override
    public void transactionCommitted(long transactionId, long checksum) {
        if (this.lastCommittedTx.offer(transactionId, checksum)) {
            long[] transactionData = this.lastCommittedTx.get();
            this.setRecord(Position.LAST_TRANSACTION_ID, transactionData[0]);
            this.setRecord(Position.LAST_TRANSACTION_CHECKSUM, transactionData[1]);
            this.lastTransactionChecksum = checksum;
        }
    }

    @Override
    public long getLastCommittedTransactionId() {
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastCommittedTx.getHighestGapFreeNumber();
    }

    @Override
    public long[] getLastCommittedTransaction() {
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastCommittedTx.get();
    }

    @Override
    public long[] getUpgradeTransaction() {
        this.checkInitialized(this.upgradeTxChecksumField);
        return new long[]{this.upgradeTxIdField, this.upgradeTxChecksumField};
    }

    @Override
    public long getLastClosedTransactionId() {
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastClosedTx.getHighestGapFreeNumber();
    }

    private void checkInitialized(long field) {
        if (field == Long.MIN_VALUE) {
            this.refreshFields();
        }
    }

    @Override
    public void setLastCommittedAndClosedTransactionId(long transactionId, long checksum) {
        this.setRecord(Position.LAST_TRANSACTION_ID, transactionId);
        this.setRecord(Position.LAST_TRANSACTION_CHECKSUM, checksum);
        this.checkInitialized(this.lastCommittingTxField.get());
        this.lastCommittingTxField.set(transactionId);
        this.lastClosedTx.set(transactionId, 0L);
        this.lastCommittedTx.set(transactionId, checksum);
        this.lastTransactionChecksum = checksum;
    }

    @Override
    public void transactionClosed(long transactionId) {
        this.lastClosedTx.offer(transactionId, 0L);
    }

    @Override
    public boolean closedTransactionIdIsOnParWithOpenedTransactionId() {
        boolean onPar;
        boolean bl = onPar = this.lastClosedTx.getHighestGapFreeNumber() == this.lastCommittingTxField.get();
        if (!onPar) {
            this.transactionCloseWaitLogger.event(null);
        }
        return onPar;
    }

    @Override
    public void visitStore(Visitor<CommonAbstractStore, RuntimeException> visitor) {
        this.nodeStore.visitStore(visitor);
        this.relStore.visitStore(visitor);
        this.relGroupStore.visitStore(visitor);
        this.relTypeStore.visitStore(visitor);
        this.labelTokenStore.visitStore(visitor);
        this.propStore.visitStore(visitor);
        this.schemaStore.visitStore(visitor);
        visitor.visit(this);
    }

    public void rebuildCountStoreIfNeeded() throws IOException {
        this.counts.start();
    }

    public static enum Position {
        TIME(0, "Creation time"),
        RANDOM_NUMBER(1, "Random number for store id"),
        LOG_VERSION(2, "Current log version"),
        LAST_TRANSACTION_ID(3, "Last committed transaction"),
        STORE_VERSION(4, "Store format version"),
        FIRST_GRAPH_PROPERTY(5, "First property record containing graph properties"),
        LAST_CONSTRAINT_TRANSACTION(6, "Last committed transaction containing constraint changes"),
        UPGRADE_TRANSACTION_ID(7, "Transaction id most recent upgrade was performed at"),
        UPGRADE_TIME(8, "Time of last upgrade"),
        LAST_TRANSACTION_CHECKSUM(9, "Checksum of last committed transaction"),
        UPGRADE_TRANSACTION_CHECKSUM(10, "Checksum of transaction id the most recent upgrade was performed at");

        private final int id;
        private final String description;

        private Position(int id, String description) {
            this.id = id;
            this.description = description;
        }

        public String description() {
            return this.description;
        }
    }

    public static abstract class Configuration
    extends CommonAbstractStore.Configuration {
        public static final Setting<Integer> relationship_grab_size = GraphDatabaseSettings.relationship_grab_size;
        public static final Setting<Integer> dense_node_threshold = GraphDatabaseSettings.dense_node_threshold;
    }
}

