/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.ArrayValue;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.IntegralArrayProperty;

abstract class FloatingPointArrayProperty
extends DefinedProperty
implements ArrayValue.FloatingPointArray {
    FloatingPointArrayProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    @Override
    public abstract int length();

    @Override
    public abstract double doubleValue(int var1);

    @Override
    final int valueHash() {
        return FloatingPointArrayProperty.hash(this);
    }

    static int hash(ArrayValue.FloatingPointArray value) {
        int result = 1;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            long element = (long)value.doubleValue(i);
            int elementHash = (int)(element ^ element >>> 32);
            result = 31 * result + elementHash;
        }
        return result;
    }

    @Override
    public final boolean valueEquals(Object other) {
        return FloatingPointArrayProperty.valueEquals(this, other);
    }

    static boolean valueEquals(ArrayValue.FloatingPointArray value, Object other) {
        if (other instanceof double[]) {
            return FloatingPointArrayProperty.numbersEqual(value, new ArrayValue.DoubleArray((double[])other));
        }
        if (other instanceof float[]) {
            return FloatingPointArrayProperty.numbersEqual(value, new ArrayValue.FloatArray((float[])other));
        }
        if (other instanceof Number[]) {
            Number[] that = (Number[])other;
            if (that.length == value.length()) {
                if (other instanceof Double[] || other instanceof Float[]) {
                    return FloatingPointArrayProperty.numbersEqual(value, ArrayValue.NumberArray.asFloatingPoint(that));
                }
                return FloatingPointArrayProperty.numbersEqual(value, ArrayValue.NumberArray.asIntegral(that));
            }
        } else {
            if (other instanceof long[]) {
                return FloatingPointArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.LongArray((long[])other));
            }
            if (other instanceof int[]) {
                return FloatingPointArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.IntArray((int[])other));
            }
            if (other instanceof short[]) {
                return FloatingPointArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.ShortArray((short[])other));
            }
            if (other instanceof byte[]) {
                return FloatingPointArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.ByteArray((byte[])other));
            }
        }
        return false;
    }

    @Override
    final boolean hasEqualValue(DefinedProperty other) {
        if (other instanceof FloatingPointArrayProperty) {
            FloatingPointArrayProperty that = (FloatingPointArrayProperty)other;
            return FloatingPointArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)this, that);
        }
        if (other instanceof IntegralArrayProperty) {
            IntegralArrayProperty that = (IntegralArrayProperty)other;
            return FloatingPointArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)this, (ArrayValue.IntegralArray)that);
        }
        return false;
    }
}

