/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

abstract class OffHeapNumberArray
implements NumberArray {
    protected final long address;
    protected final long length;
    protected final int shift;
    protected final int stride;
    private boolean closed;

    protected OffHeapNumberArray(long length, int shift) {
        UnsafeUtil.assertHasUnsafe();
        this.length = length;
        this.shift = shift;
        this.stride = 1 << shift;
        this.address = UnsafeUtil.malloc((long)(length << shift));
    }

    @Override
    public long length() {
        return this.length;
    }

    protected long addressOf(long index) {
        if (index < 0L || index >= this.length) {
            throw new ArrayIndexOutOfBoundsException("Requested index " + index + ", but length is " + this.length);
        }
        return this.address + (index << this.shift);
    }

    protected boolean isByteUniform(long value) {
        byte any = 0;
        for (int i = 0; i < this.stride; ++i) {
            byte test = (byte)(value >>> 8 * i);
            if (i == 0) {
                any = test;
                continue;
            }
            if (test == any) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.length * (long)this.stride);
    }

    @Override
    public void close() {
        if (!this.closed) {
            UnsafeUtil.free((long)this.address);
            this.closed = true;
        }
    }
}

