/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockClient;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class CommunityLockManger
extends LifecycleAdapter
implements Locks {
    private final LockManagerImpl manager = new LockManagerImpl(new RagManager());

    @Override
    public Locks.Client newClient() {
        return new CommunityLockClient(this.manager);
    }

    @Override
    public void accept(final Locks.Visitor visitor) {
        this.manager.accept(new Visitor<RWLock, RuntimeException>(){

            @Override
            public boolean visit(RWLock element) throws RuntimeException {
                Object resource = element.resource();
                if (resource instanceof LockResource) {
                    LockResource lockResource = (LockResource)resource;
                    visitor.visit(lockResource.type(), lockResource.resourceId(), element.describe(), element.maxWaitTime());
                }
                return false;
            }
        });
    }
}

