/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.CacheUpdateListener;
import org.neo4j.kernel.impl.cache.SizeOfObject;
import org.neo4j.kernel.impl.store.InvalidRecordException;

public abstract class Primitive
implements SizeOfObject {
    protected static final DefinedProperty[] NO_PROPERTIES = new DefinedProperty[0];

    public abstract long getId();

    public Iterator<DefinedProperty> getProperties(CacheLoader<Iterator<DefinedProperty>> loader, CacheUpdateListener updateListener) {
        return this.ensurePropertiesLoaded(loader, updateListener);
    }

    public Property getProperty(CacheLoader<Iterator<DefinedProperty>> loader, CacheUpdateListener updateListener, int key) {
        this.ensurePropertiesLoaded(loader, updateListener);
        return this.getCachedProperty(key);
    }

    public PrimitiveLongIterator getPropertyKeys(CacheLoader<Iterator<DefinedProperty>> cacheLoader, CacheUpdateListener updateListener) {
        this.ensurePropertiesLoaded(cacheLoader, updateListener);
        return this.getCachedPropertyKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<DefinedProperty> ensurePropertiesLoaded(CacheLoader<Iterator<DefinedProperty>> loader, CacheUpdateListener updateListener) {
        if (!this.hasLoadedProperties()) {
            Primitive primitive = this;
            synchronized (primitive) {
                if (!this.hasLoadedProperties()) {
                    try {
                        Iterator<DefinedProperty> loadedProperties = loader.load(this.getId());
                        this.setProperties(loadedProperties);
                        updateListener.newSize(this, this.sizeOfObjectInBytesIncludingOverhead());
                    }
                    catch (EntityNotFoundException | InvalidRecordException e) {
                        throw new NotFoundException(this + " not found. This can be because someone " + "else deleted this entity while we were trying to read properties from it, or because of " + "concurrent modification of other properties on this entity. The problem should be temporary.", e);
                    }
                }
            }
        }
        return this.getCachedProperties();
    }

    protected abstract Iterator<DefinedProperty> getCachedProperties();

    protected abstract Property getCachedProperty(int var1);

    protected abstract PrimitiveLongIterator getCachedPropertyKeys();

    protected abstract boolean hasLoadedProperties();

    protected abstract void setProperties(Iterator<DefinedProperty> var1);

    public abstract void commitPropertyMaps(PrimitiveIntObjectMap<DefinedProperty> var1, Iterator<Integer> var2);

    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }

    public abstract boolean equals(Object var1);
}

