/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.PropertyTracker;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.EntityFactory;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;

public class LegacyPropertyTrackers {
    private final List<PropertyTracker<Node>> nodeTrackers;
    private final List<PropertyTracker<Relationship>> relationshipTrackers;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final EntityFactory entityFactory;

    public LegacyPropertyTrackers(PropertyKeyTokenHolder propertyKeyTokenHolder, List<PropertyTracker<Node>> nodeTrackers, List<PropertyTracker<Relationship>> relationshipTrackers, EntityFactory entityFactory) {
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.nodeTrackers = nodeTrackers;
        this.relationshipTrackers = relationshipTrackers;
        this.entityFactory = entityFactory;
    }

    public void nodeAddStoreProperty(long nodeId, DefinedProperty property) {
        if (!this.nodeTrackers.isEmpty()) {
            Node node = this.entityFactory.newNodeProxyById(nodeId);
            for (PropertyTracker<Node> tracker : this.nodeTrackers) {
                tracker.propertyAdded(node, this.propertyKeyName(property), property.value());
            }
        }
    }

    public void nodeChangeStoreProperty(long nodeId, DefinedProperty previousProperty, DefinedProperty property) {
        if (!this.nodeTrackers.isEmpty()) {
            Node node = this.entityFactory.newNodeProxyById(nodeId);
            for (PropertyTracker<Node> tracker : this.nodeTrackers) {
                tracker.propertyChanged(node, this.propertyKeyName(property), previousProperty.value(null), property.value(null));
            }
        }
    }

    public void relationshipAddStoreProperty(long relationshipId, DefinedProperty property) {
        if (!this.relationshipTrackers.isEmpty()) {
            Relationship relationship = this.entityFactory.newRelationshipProxyById(relationshipId);
            for (PropertyTracker<Relationship> tracker : this.relationshipTrackers) {
                tracker.propertyAdded(relationship, this.propertyKeyName(property), property.value());
            }
        }
    }

    public void relationshipChangeStoreProperty(long relationshipId, DefinedProperty previousProperty, DefinedProperty property) {
        if (!this.relationshipTrackers.isEmpty()) {
            Relationship relationship = this.entityFactory.newRelationshipProxyById(relationshipId);
            for (PropertyTracker<Relationship> tracker : this.relationshipTrackers) {
                tracker.propertyChanged(relationship, this.propertyKeyName(property), previousProperty.value(null), property.value(null));
            }
        }
    }

    public void nodeRemoveStoreProperty(long nodeId, DefinedProperty property) {
        if (!this.nodeTrackers.isEmpty()) {
            Node node = this.entityFactory.newNodeProxyById(nodeId);
            for (PropertyTracker<Node> tracker : this.nodeTrackers) {
                tracker.propertyRemoved(node, this.propertyKeyName(property), property.value());
            }
        }
    }

    public void relationshipRemoveStoreProperty(long relationshipId, DefinedProperty property) {
        if (!this.relationshipTrackers.isEmpty()) {
            Relationship relationship = this.entityFactory.newRelationshipProxyById(relationshipId);
            for (PropertyTracker<Relationship> tracker : this.relationshipTrackers) {
                tracker.propertyRemoved(relationship, this.propertyKeyName(property), property.value());
            }
        }
    }

    private String propertyKeyName(Property property) {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(property.propertyKeyId())).name();
        }
        catch (TokenNotFoundException e) {
            throw new IllegalStateException("Property key " + property.propertyKeyId() + " should exist");
        }
    }

    public void nodeDelete(long nodeId) {
        if (!this.nodeTrackers.isEmpty()) {
            Node node = this.entityFactory.newNodeProxyById(nodeId);
            Iterable<String> propertyKeys = node.getPropertyKeys();
            for (String key : propertyKeys) {
                Object value = node.getProperty(key);
                for (PropertyTracker<Node> tracker : this.nodeTrackers) {
                    tracker.propertyRemoved(node, key, value);
                }
            }
        }
    }

    public void relationshipDelete(long relationshipId) {
        if (!this.relationshipTrackers.isEmpty()) {
            Relationship relationship = this.entityFactory.newRelationshipProxyById(relationshipId);
            Iterable<String> propertyKeys = relationship.getPropertyKeys();
            for (String key : propertyKeys) {
                Object value = relationship.getProperty(key);
                for (PropertyTracker<Relationship> tracker : this.relationshipTrackers) {
                    tracker.propertyRemoved(relationship, key, value);
                }
            }
        }
    }
}

