/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;

@Deprecated
public class TopLevelTransaction
implements Transaction {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final ThreadToStatementContextBridge stmtProvider;
    private final TransactionOutcome transactionOutcome = new TransactionOutcome();
    private final KernelTransaction transaction;

    public TopLevelTransaction(KernelTransaction transaction, ThreadToStatementContextBridge stmtProvider) {
        this.transaction = transaction;
        this.stmtProvider = stmtProvider;
    }

    @Override
    public void failure() {
        this.transactionOutcome.failed();
        this.transaction.failure();
    }

    @Override
    public void success() {
        this.transactionOutcome.success();
        this.transaction.success();
    }

    @Override
    public final void finish() {
        this.close();
    }

    @Override
    public final void terminate() {
        this.transaction.markForTermination();
    }

    @Override
    public void close() {
        try {
            if (this.transaction.isOpen()) {
                this.transaction.close();
            }
        }
        catch (DeadlockDetectedException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.transactionOutcome.successCalled()) {
                throw new TransactionFailureException("Transaction was marked as successful, but unable to commit transaction so rolled back.", e);
            }
            throw new TransactionFailureException("Unable to rollback transaction", e);
        }
        finally {
            this.stmtProvider.unbindTransactionFromCurrentThread();
        }
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer entity) {
        return locker.exclusiveLock(this.stmtProvider, entity);
    }

    @Override
    public Lock acquireReadLock(PropertyContainer entity) {
        return locker.sharedLock(this.stmtProvider, entity);
    }

    @Deprecated
    public KernelTransaction getTransaction() {
        return this.transaction;
    }

    TransactionOutcome getTransactionOutcome() {
        return this.transactionOutcome;
    }

    static class TransactionOutcome {
        private boolean success = false;
        private boolean failure = false;

        TransactionOutcome() {
        }

        public void failed() {
            this.failure = true;
        }

        public void success() {
            this.success = true;
        }

        public boolean canCommit() {
            return this.success && !this.failure;
        }

        public boolean successCalled() {
            return this.success;
        }

        public boolean failureCalled() {
            return this.failure;
        }
    }
}

