/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest;

import java.util.concurrent.Callable;
import java.util.function.BooleanSupplier;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.Runner;

public class Builder {
    private BooleanSupplier condition;
    private DatabaseLayout databaseLayout;
    private int threads;

    public Builder with(BooleanSupplier condition) {
        this.condition = condition;
        return this;
    }

    public Builder withWorkingDirectory(DatabaseLayout databaseLayout) {
        this.databaseLayout = databaseLayout;
        return this;
    }

    public Builder withNumThreads(int threads) {
        this.threads = threads;
        return this;
    }

    public Callable<Long> build() {
        return new Runner(this.databaseLayout, this.condition, this.threads);
    }
}

