/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.scheduler.ActiveGroup;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.FailedJobRun;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.JobSchedulerExtension;
import org.neo4j.scheduler.MonitoredJobExecutor;
import org.neo4j.scheduler.MonitoredJobInfo;
import org.neo4j.scheduler.SchedulerThreadFactoryFactory;

class TraceableJobExecutionScheduler
extends JobSchedulerExtension {
    TraceableJobExecutionScheduler() {
    }

    @Override
    protected JobScheduler createField(ExtensionContext context) {
        return new TestJobScheduler(super.createField(context));
    }

    private static class TestJobScheduler
    implements JobScheduler {
        private final JobScheduler originalScheduler;

        TestJobScheduler(JobScheduler originalScheduler) {
            this.originalScheduler = originalScheduler;
        }

        public void init() throws Exception {
            this.originalScheduler.init();
        }

        public void start() throws Exception {
            this.originalScheduler.start();
        }

        public void stop() throws Exception {
            this.originalScheduler.stop();
        }

        public void shutdown() throws Exception {
            this.originalScheduler.shutdown();
        }

        public void setTopLevelGroupName(String name) {
            this.originalScheduler.setTopLevelGroupName(name);
        }

        public void setParallelism(Group group, int parallelism) {
            this.originalScheduler.setParallelism(group, parallelism);
        }

        public void setThreadFactory(Group group, SchedulerThreadFactoryFactory threadFactory) {
            this.originalScheduler.setThreadFactory(group, threadFactory);
        }

        public CallableExecutor executor(Group group) {
            return this.originalScheduler.executor(group);
        }

        public MonitoredJobExecutor monitoredJobExecutor(Group group) {
            return this.originalScheduler.monitoredJobExecutor(group);
        }

        public ThreadFactory threadFactory(Group group) {
            return this.originalScheduler.threadFactory(group);
        }

        public <T> JobHandle<T> schedule(Group group, JobMonitoringParams jobMonitoringParams, Callable<T> job) {
            return this.originalScheduler.schedule(group, jobMonitoringParams, job);
        }

        public JobHandle<?> schedule(Group group, Runnable job) {
            return this.originalScheduler.schedule(group, job);
        }

        public JobHandle<?> schedule(Group group, JobMonitoringParams monitoredJobParams, Runnable job) {
            return this.originalScheduler.schedule(group, monitoredJobParams, job);
        }

        public JobHandle<?> schedule(Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
            return this.originalScheduler.schedule(group, runnable, initialDelay, timeUnit);
        }

        public JobHandle<?> schedule(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
            return this.originalScheduler.schedule(group, monitoredJobParams, runnable, initialDelay, timeUnit);
        }

        public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
            return this.originalScheduler.scheduleRecurring(group, runnable, period, timeUnit);
        }

        public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long period, TimeUnit timeUnit) {
            return this.originalScheduler.scheduleRecurring(group, monitoredJobParams, runnable, period, timeUnit);
        }

        public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
            return this.originalScheduler.scheduleRecurring(group, runnable, initialDelay, period, timeUnit);
        }

        public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
            return this.originalScheduler.scheduleRecurring(group, monitoredJobParams, runnable, initialDelay, period, timeUnit);
        }

        public Stream<ActiveGroup> activeGroups() {
            return this.originalScheduler.activeGroups();
        }

        public List<MonitoredJobInfo> getMonitoredJobs() {
            return this.originalScheduler.getMonitoredJobs();
        }

        public List<FailedJobRun> getFailedJobRuns() {
            return this.originalScheduler.getFailedJobRuns();
        }

        public void close() throws Exception {
            this.originalScheduler.close();
            throw new RuntimeException("Shutdown called.");
        }
    }
}

