/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class MockIndexProviderMap
extends LifecycleAdapter
implements IndexProviderMap {
    private final IndexProvider indexProvider;

    public MockIndexProviderMap(IndexProvider indexProvider) {
        this.indexProvider = indexProvider;
    }

    public void init() {
    }

    public IndexProvider getDefaultProvider() {
        return this.indexProvider;
    }

    public IndexProvider getFulltextProvider() {
        throw new UnsupportedOperationException();
    }

    public IndexProvider getTokenIndexProvider() {
        throw new UnsupportedOperationException();
    }

    public IndexProvider getTextIndexProvider() {
        throw new UnsupportedOperationException();
    }

    public IndexProvider getPointIndexProvider() {
        throw new UnsupportedOperationException();
    }

    public IndexProvider lookup(IndexProviderDescriptor providerDescriptor) {
        if (this.indexProvider.getProviderDescriptor().equals((Object)providerDescriptor)) {
            return this.indexProvider;
        }
        throw new IndexProviderNotFoundException("lookup by descriptor failed");
    }

    public IndexProvider lookup(String providerDescriptorName) {
        if (this.indexProvider.getProviderDescriptor().name().equals(providerDescriptorName)) {
            return this.indexProvider;
        }
        throw new IndexProviderNotFoundException("lookup by descriptor name failed");
    }

    public List<IndexProvider> lookup(IndexType indexType) {
        if (this.indexProvider.getIndexType().equals((Object)indexType)) {
            return Collections.singletonList(this.indexProvider);
        }
        throw new IndexProviderNotFoundException("lookup by type failed");
    }

    public void accept(Consumer<IndexProvider> visitor) {
        throw new UnsupportedOperationException();
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        IndexProviderDescriptor providerDescriptor = index.getIndexProvider();
        IndexProvider provider = this.lookup(providerDescriptor);
        return provider.completeConfiguration(index, indexingBehaviour);
    }
}

