/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.pool.Pool;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.readonly.DefaultReadOnlyDatabases;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.version.DefaultVersionStorageTracer;
import org.neo4j.io.pagecache.tracing.version.VersionStorageTracer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.tracer.DefaultTracer;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.lock.LockTracer;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.resources.CpuClock;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;

class KernelTransactionTestBase {
    protected final StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class, (Answer)Mockito.RETURNS_MOCKS);
    protected final StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
    protected final MetadataProvider metadataProvider = (MetadataProvider)Mockito.mock(MetadataProvider.class);
    protected final CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
    protected final TransactionMonitor transactionMonitor = (TransactionMonitor)Mockito.mock(TransactionMonitor.class);
    protected final CapturingCommitProcess commitProcess = new CapturingCommitProcess();
    protected final AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
    protected final FakeClock clock = Clocks.fakeClock();
    protected final Pool<KernelTransactionImplementation> txPool = (Pool)Mockito.mock(Pool.class);
    protected final Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
    protected CollectionsFactory collectionsFactory;
    protected final Config config = Config.defaults();
    private final long defaultTransactionTimeoutMillis = ((Duration)this.config.get(GraphDatabaseSettings.transaction_timeout)).toMillis();

    KernelTransactionTestBase() {
    }

    @BeforeEach
    public void before() throws Exception {
        this.collectionsFactory = (CollectionsFactory)Mockito.spy((Object)new TestCollectionsFactory());
        Mockito.when((Object)this.storageEngine.newReader()).thenReturn((Object)this.storageReader);
        Mockito.when((Object)this.storageEngine.newCommandCreationContext()).thenReturn((Object)this.commandCreationContext);
        Mockito.when((Object)this.storageEngine.metadataProvider()).thenReturn((Object)this.metadataProvider);
        Mockito.when((Object)this.storageEngine.createStorageCursors((CursorContext)ArgumentMatchers.any())).thenReturn((Object)StoreCursors.NULL);
        Mockito.when((Object)this.storageEngine.createCommands((ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (StorageReader)ArgumentMatchers.any(StorageReader.class), (CommandCreationContext)ArgumentMatchers.any(CommandCreationContext.class), (LockTracer)ArgumentMatchers.any(LockTracer.class), (TxStateVisitor.Decorator)ArgumentMatchers.any(TxStateVisitor.Decorator.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (StoreCursors)ArgumentMatchers.any(StoreCursors.class), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class))).thenReturn(List.of(new TestCommand()));
    }

    public KernelTransactionImplementation newTransaction(long transactionTimeoutMillis) {
        return this.newTransaction(0L, LoginContext.AUTH_DISABLED, transactionTimeoutMillis, 1L);
    }

    public KernelTransactionImplementation newTransaction(LoginContext loginContext) {
        return this.newTransaction(0L, loginContext, this.defaultTransactionTimeoutMillis, 1L);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, LoginContext loginContext, long transactionTimeout, long userTransactionId) {
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        this.initialize(lastTransactionIdWhenStarted, loginContext, transactionTimeout, userTransactionId, tx);
        return tx;
    }

    void initialize(long lastTransactionIdWhenStarted, LoginContext loginContext, long transactionTimeout, long userTransactionId, KernelTransactionImplementation tx) {
        SecurityContext securityContext = loginContext.authorize(LoginContext.IdLookup.EMPTY, "neo4j", (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG);
        tx.initialize(lastTransactionIdWhenStarted, KernelTransaction.Type.EXPLICIT, securityContext, transactionTimeout, userTransactionId, ClientConnectionInfo.EMBEDDED_CONNECTION);
    }

    KernelTransactionImplementation newNotInitializedTransaction() {
        return this.newNotInitializedTransaction(LeaseService.NO_LEASES, this.config, DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()));
    }

    KernelTransactionImplementation newNotInitializedTransaction(Config config) {
        return this.newNotInitializedTransaction(LeaseService.NO_LEASES, config, DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()));
    }

    KernelTransactionImplementation newNotInitializedTransaction(Config config, NamedDatabaseId databaseId) {
        return this.newNotInitializedTransaction(LeaseService.NO_LEASES, config, databaseId);
    }

    KernelTransactionImplementation newNotInitializedTransaction(LeaseService leaseService, Config config, NamedDatabaseId databaseId) {
        Dependencies dependencies = new Dependencies();
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)this.locksClient);
        dependencies.satisfyDependency((Object)((GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class)));
        GlobalMemoryGroupTracker memoryPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, ByteUnit.mebiBytes((long)4L), null);
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName(databaseId.name())).thenReturn(Optional.of(databaseId));
        ConfigBasedLookupFactory readOnlyLookup = new ConfigBasedLookupFactory(config, databaseIdRepository);
        DefaultReadOnlyDatabases readOnlyChecker = new DefaultReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{readOnlyLookup});
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        DefaultVersionStorageTracer versionStorageTracer = new DefaultVersionStorageTracer((PageCacheTracer)pageCacheTracer);
        return new KernelTransactionImplementation(config, (DatabaseTransactionEventListeners)Mockito.mock(DatabaseTransactionEventListeners.class), null, null, (TransactionCommitProcess)this.commitProcess, this.transactionMonitor, this.txPool, (SystemNanoClock)this.clock, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new DatabaseTracers((DatabaseTracer)new DefaultTracer((PageCacheTracer)pageCacheTracer), LockTracer.NONE, (PageCacheTracer)pageCacheTracer, (VersionStorageTracer)versionStorageTracer), this.storageEngine, any -> CanWrite.INSTANCE, new CursorContextFactory((PageCacheTracer)pageCacheTracer, EmptyVersionContextSupplier.EMPTY), () -> this.collectionsFactory, (ConstraintSemantics)new StandardConstraintSemantics(), (SchemaState)Mockito.mock(SchemaState.class), KernelTransactionTestBase.mockedTokenHolders(), (ElementIdMapper)Mockito.mock(ElementIdMapper.class), (IndexingService)Mockito.mock(IndexingService.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), dependencies, databaseId, leaseService, (ScopedMemoryPool)memoryPool, readOnlyChecker.forDatabase(databaseId), TransactionExecutionMonitor.NO_OP, (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG, locks, (TransactionCommitmentFactory)Mockito.mock(TransactionCommitmentFactory.class), (KernelTransactions)Mockito.mock(KernelTransactions.class), TransactionIdGenerator.EMPTY, (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class), KernelVersionProvider.LATEST_VERSION, (LogProvider)NullLogProvider.getInstance(), this.storageEngine.getOpenOptions().contains((Object)PageCacheOpenOptions.MULTI_VERSIONED));
    }

    KernelTransactionImplementation newNotInitializedTransaction(LeaseService leaseService) {
        return this.newNotInitializedTransaction(leaseService, this.config, DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()));
    }

    private static TokenHolders mockedTokenHolders() {
        return new TokenHolders((TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class));
    }

    public static class CapturingCommitProcess
    implements TransactionCommitProcess {
        private long txId = 1L;
        public List<CommandBatch> transactions = new ArrayList<CommandBatch>();

        public long commit(CommandBatchToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) {
            this.transactions.add(batch.commandBatch());
            return ++this.txId;
        }
    }

    private static class TestCollectionsFactory
    implements CollectionsFactory {
        private TestCollectionsFactory() {
        }

        public MutableLongSet newLongSet(MemoryTracker memoryTracker) {
            return OnHeapCollectionsFactory.INSTANCE.newLongSet(memoryTracker);
        }

        public MutableLongDiffSets newLongDiffSets(MemoryTracker memoryTracker) {
            return OnHeapCollectionsFactory.INSTANCE.newLongDiffSets(memoryTracker);
        }

        public MutableLongObjectMap<Value> newValuesMap(MemoryTracker memoryTracker) {
            return new LongObjectHashMap();
        }

        public void release() {
        }
    }
}

