/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import org.junit.jupiter.api.Assertions;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.values.storable.Values;

class PropertyEntryImpl<T>
implements PropertyEntry<T> {
    private final T entity;
    private final String key;
    private final Object value;
    private final Object valueBeforeTx;

    PropertyEntryImpl(T entity, String key, Object value, Object valueBeforeTx) {
        this.entity = entity;
        this.key = key;
        this.value = value;
        this.valueBeforeTx = valueBeforeTx;
    }

    public T entity() {
        return this.entity;
    }

    public String key() {
        return this.key;
    }

    public Object value() {
        return this.value;
    }

    public Object previouslyCommittedValue() {
        return this.valueBeforeTx;
    }

    void compareToAssigned(PropertyEntry<T> entry) {
        this.basicCompareTo(entry);
        PropertyEntryImpl.assertEqualsMaybeNull(entry.value(), this.value(), entry.entity(), entry.key());
    }

    void compareToRemoved(PropertyEntry<T> entry) {
        this.basicCompareTo(entry);
        try {
            entry.value();
            Assertions.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertNull((Object)this.value());
    }

    private void basicCompareTo(PropertyEntry<T> entry) {
        Assertions.assertEquals((Object)entry.entity(), this.entity());
        Assertions.assertEquals((Object)entry.key(), (Object)this.key());
        PropertyEntryImpl.assertEqualsMaybeNull(entry.previouslyCommittedValue(), this.previouslyCommittedValue(), entry.entity(), entry.key());
    }

    public String toString() {
        return "PropertyEntry[entity=" + String.valueOf(this.entity) + ", key=" + this.key + ", value=" + String.valueOf(this.value) + ", valueBeforeTx=" + String.valueOf(this.valueBeforeTx) + "]";
    }

    private static <T> void assertEqualsMaybeNull(Object o1, Object o2, T entity, String key) {
        String entityDescription = "For " + String.valueOf(entity) + " and " + key;
        if (o1 == null || o2 == null) {
            Assertions.assertSame((Object)o1, (Object)o2, (String)(entityDescription + ". " + Strings.prettyPrint((Object)o1) + " != " + Strings.prettyPrint((Object)o2)));
        } else {
            Assertions.assertEquals((Object)Values.of((Object)o1), (Object)Values.of((Object)o2), (String)entityDescription);
        }
    }
}

