/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.test.LatestVersions;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class CommandReaderFactoryTestBase<FACTORY extends CommandReaderFactory> {
    private final FACTORY factory;

    protected CommandReaderFactoryTestBase(FACTORY factory) {
        this.factory = factory;
    }

    protected abstract Iterable<KernelVersion> supported();

    protected abstract Iterable<KernelVersion> unsupported();

    @ParameterizedTest
    @MethodSource(value={"unsupported"})
    void shouldThrowOnSupportedVersions(KernelVersion kernelVersion) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.get(kernelVersion), (String)"acquiring reader for unsupported kernel version", (Object[])new Object[0]).isInstanceOf(IllegalStateException.class)).hasMessageContainingAll(new CharSequence[]{"Serialization is not supported", kernelVersion.name()});
    }

    @ParameterizedTest
    @MethodSource(value={"supported"})
    void shouldProviderReaderWithCorrespondingKernelVersion(KernelVersion kernelVersion) {
        this.assertReaderHandlesKernelVersions(kernelVersion);
    }

    @Test
    void shouldProviderReaderForGloriousFuture() {
        this.assertReaderHandlesKernelVersions(KernelVersion.GLORIOUS_FUTURE);
        ((ObjectAssert)Assertions.assertThat((Object)this.factory.get(KernelVersion.GLORIOUS_FUTURE)).as("reader for %s should be based upon reader for latest kernel version", new Object[]{KernelVersion.GLORIOUS_FUTURE})).isInstanceOf(this.factory.get(LatestVersions.LATEST_KERNEL_VERSION).getClass());
    }

    private void assertReaderHandlesKernelVersions(KernelVersion kernelVersion) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.factory.get(kernelVersion).kernelVersion()).as("reader should handle %s", new Object[]{kernelVersion})).isEqualTo((Object)kernelVersion);
    }
}

