/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class SimpleTransactionIdStore
implements TransactionIdStore {
    private final AtomicLong committingTransactionId = new AtomicLong();
    private final OutOfOrderSequence closedTransactionId = new ArrayQueueOutOfOrderSequence(-1L, 100, OutOfOrderSequence.EMPTY_META);
    private final AtomicReference<TransactionId> committedTransactionId = new AtomicReference<TransactionId>(BASE_TRANSACTION_ID);

    public SimpleTransactionIdStore() {
        this(1L, 1L, KernelVersion.DEFAULT_BOOTSTRAP_VERSION, -559063315, 0L, -1L, 0L, 64L);
    }

    public SimpleTransactionIdStore(long previouslyCommittedTxId, long appendIndex, KernelVersion kernelVersion, int checksum, long previouslyCommittedTxCommitTimestamp, long previousConsensusIndex, long previouslyCommittedTxLogVersion, long previouslyCommittedTxLogByteOffset) {
        assert (previouslyCommittedTxId >= 1L) : "cannot start from a tx id less than BASE_TX_ID";
        this.setLastCommittedAndClosedTransactionId(previouslyCommittedTxId, appendIndex, kernelVersion, checksum, previouslyCommittedTxCommitTimestamp, previousConsensusIndex, previouslyCommittedTxLogByteOffset, previouslyCommittedTxLogVersion, appendIndex);
    }

    public long nextCommittingTransactionId() {
        return this.committingTransactionId.incrementAndGet();
    }

    public long committingTransactionId() {
        return this.committingTransactionId.get();
    }

    public synchronized void transactionCommitted(long transactionId, long appendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex) {
        TransactionId current = this.committedTransactionId.get();
        if (current == null || transactionId > current.id()) {
            this.committedTransactionId.set(new TransactionId(transactionId, appendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex));
        }
    }

    public long getLastCommittedTransactionId() {
        return this.committedTransactionId.get().id();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.committedTransactionId.get();
    }

    public long getLastClosedTransactionId() {
        return this.closedTransactionId.getHighestGapFreeNumber();
    }

    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        return new TransactionIdSnapshot(this.closedTransactionId.reverseSnapshot());
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        return new ClosedTransactionMetadata(this.closedTransactionId.get());
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, long transactionAppendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex, long byteOffset, long logVersion, long appendIndex) {
        this.committingTransactionId.set(transactionId);
        this.committedTransactionId.set(new TransactionId(transactionId, transactionAppendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex));
        this.closedTransactionId.set(transactionId, new OutOfOrderSequence.Meta(logVersion, byteOffset, kernelVersion.version(), checksum, commitTimestamp, consensusIndex, transactionAppendIndex));
    }

    public void transactionClosed(long transactionId, long appendIndex, KernelVersion kernelVersion, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.closedTransactionId.offer(transactionId, new OutOfOrderSequence.Meta(logVersion, byteOffset, kernelVersion.version(), checksum, commitTimestamp, consensusIndex, appendIndex));
    }

    public void resetLastClosedTransaction(long transactionId, long appendIndex, KernelVersion kernelVersion, long byteOffset, long logVersion, int checksum, long commitTimestamp, long consensusIndex) {
        this.closedTransactionId.set(transactionId, new OutOfOrderSequence.Meta(logVersion, byteOffset, kernelVersion.version(), checksum, commitTimestamp, consensusIndex, appendIndex));
    }

    public void appendBatch(long appendIndex, LogPosition logPositionBeforeAppendIndex) {
    }
}

