/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.enrichment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.enrichment.TxMetadata;
import org.neo4j.storageengine.api.enrichment.WriteEnrichmentChannel;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Enrichment
implements AutoCloseable {
    protected final TxMetadata metadata;

    protected Enrichment(TxMetadata metadata) {
        this.metadata = metadata;
    }

    public static TxMetadata readMetadataAndPastEnrichmentData(ReadableChannel channel) throws IOException {
        int toSkip;
        TxMetadata metadata = TxMetadata.deserialize(channel);
        long entitiesSize = channel.getInt();
        long detailsSize = channel.getInt();
        long changesSize = channel.getInt();
        long valuesSize = channel.getInt();
        long blocksSizes = entitiesSize + detailsSize + changesSize + valuesSize;
        byte[] bytes = new byte[32768];
        for (int remaining = (int)blocksSizes; remaining > 0; remaining -= toSkip) {
            toSkip = Math.min(remaining, bytes.length);
            channel.get(bytes, toSkip);
        }
        return metadata;
    }

    public abstract void serialize(WritableChannel var1) throws IOException;

    @Override
    public abstract void close();

    public TxMetadata metadata() {
        return this.metadata;
    }

    public static final class Write
    extends Enrichment {
        private final WriteEnrichmentChannel entities;
        private final WriteEnrichmentChannel details;
        private final WriteEnrichmentChannel changes;
        private final WriteEnrichmentChannel values;

        public Write(TxMetadata metadata, WriteEnrichmentChannel entities, WriteEnrichmentChannel details, WriteEnrichmentChannel changes, WriteEnrichmentChannel values) {
            super(metadata);
            this.entities = Objects.requireNonNull(entities);
            this.details = Objects.requireNonNull(details);
            this.changes = Objects.requireNonNull(changes);
            this.values = Objects.requireNonNull(values);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            this.metadata.serialize(channel);
            channel.putInt(this.entities.position());
            channel.putInt(this.details.position());
            channel.putInt(this.changes.position());
            channel.putInt(this.values.position());
            this.entities.serialize(channel);
            this.details.serialize(channel);
            this.changes.serialize(channel);
            this.values.serialize(channel);
        }

        public long totalSize() {
            return 16 + this.entities.position() + this.details.position() + this.changes.position() + this.values.position();
        }

        @Override
        public void close() {
            this.entities.close();
            this.details.close();
            this.changes.close();
            this.values.close();
        }
    }

    public static final class Read
    extends Enrichment {
        private final int entityCount;
        private final ByteBuffer entitiesBuffer;
        private final ByteBuffer detailsBuffer;
        private final ByteBuffer changesBuffer;
        private final ByteBuffer valuesBuffer;
        private final MemoryTracker memoryTracker;

        private Read(TxMetadata metadata, int entityCount, ByteBuffer entitiesBuffer, ByteBuffer detailsBuffer, ByteBuffer changesBuffer, ByteBuffer valuesBuffer, MemoryTracker memoryTracker) {
            super(metadata);
            this.entityCount = entityCount;
            this.entitiesBuffer = entitiesBuffer;
            this.detailsBuffer = detailsBuffer;
            this.changesBuffer = changesBuffer;
            this.valuesBuffer = valuesBuffer;
            this.memoryTracker = memoryTracker;
        }

        public static Read deserialize(ReadableChannel channel, MemoryTracker memoryTracker) throws IOException {
            TxMetadata txMetadata = TxMetadata.deserialize(channel);
            int entitiesSize = channel.getInt();
            int detailsSize = channel.getInt();
            int changesSize = channel.getInt();
            int valuesSize = channel.getInt();
            return new Read(txMetadata, entitiesSize / 4, Read.readIntoBuffer(channel, entitiesSize, memoryTracker), Read.readIntoBuffer(channel, detailsSize, memoryTracker), Read.readIntoBuffer(channel, changesSize, memoryTracker), Read.readIntoBuffer(channel, valuesSize, memoryTracker), memoryTracker);
        }

        private static ByteBuffer readIntoBuffer(ReadableChannel channel, int size, MemoryTracker memoryTracker) throws IOException {
            memoryTracker.allocateHeap((long)size);
            ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
            int read = channel.read(buffer);
            assert (read == size) : "Unable to read all the expected data into the buffer";
            return buffer.flip();
        }

        public int numberOfEntities() {
            return this.entityCount;
        }

        public ByteBuffer entities() {
            return Read.slice(this.entitiesBuffer);
        }

        public ByteBuffer entityDetails() {
            return Read.slice(this.detailsBuffer);
        }

        public ByteBuffer entityChanges() {
            return Read.slice(this.changesBuffer);
        }

        public ByteBuffer values() {
            return Read.slice(this.valuesBuffer);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            throw new IOException("This command is only for reading and contains no enrichment data");
        }

        @Override
        public void close() {
            this.memoryTracker.releaseHeap((long)this.entitiesBuffer.capacity());
            this.memoryTracker.releaseHeap((long)this.detailsBuffer.capacity());
            this.memoryTracker.releaseHeap((long)this.changesBuffer.capacity());
            this.memoryTracker.releaseHeap((long)this.valuesBuffer.capacity());
        }

        private static ByteBuffer slice(ByteBuffer buffer) {
            return buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        }
    }
}

