/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.ExistenceConstraintDescriptor;
import org.neo4j.util.Preconditions;

public interface SchemaRule44 {
    public static final IndexProviderDescriptor NATIVE_BTREE_10 = new IndexProviderDescriptor("native-btree", "1.0");
    public static final IndexProviderDescriptor LUCENE_NATIVE_30 = new IndexProviderDescriptor("lucene+native", "3.0");

    public long id();

    public String userDescription(TokenNameLookup var1);

    public SchemaRule convertTo50rule();

    public static enum ConstraintRuleType {
        UNIQUE(true, ConstraintType.UNIQUE),
        EXISTS(false, ConstraintType.EXISTS),
        UNIQUE_EXISTS(true, ConstraintType.UNIQUE_EXISTS);

        private boolean isIndexBacked;
        private final ConstraintType constraintType;

        private ConstraintRuleType(boolean isIndexBacked, ConstraintType constraintType) {
            this.isIndexBacked = isIndexBacked;
            this.constraintType = constraintType;
        }

        public boolean isIndexBacked() {
            return this.isIndexBacked;
        }

        public ConstraintType asConstraintType() {
            return this.constraintType;
        }
    }

    public static enum IndexType {
        BTREE,
        FULLTEXT,
        LOOKUP,
        TEXT,
        RANGE,
        POINT;


        org.neo4j.internal.schema.IndexType convertIndexType() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BTREE -> throw new IllegalStateException("Trying to convert unsupported index type 'BTREE'");
                case FULLTEXT -> org.neo4j.internal.schema.IndexType.FULLTEXT;
                case LOOKUP -> org.neo4j.internal.schema.IndexType.LOOKUP;
                case TEXT -> org.neo4j.internal.schema.IndexType.TEXT;
                case RANGE -> org.neo4j.internal.schema.IndexType.RANGE;
                case POINT -> org.neo4j.internal.schema.IndexType.POINT;
            };
        }
    }

    public record Constraint(long id, SchemaDescriptor schema, String name, ConstraintRuleType constraintRuleType, Long ownedIndex, IndexType indexType) implements SchemaRule44
    {
        @Override
        public String userDescription(TokenNameLookup tokenNameLookup) {
            return SchemaUserDescription.forConstraint((TokenNameLookup)tokenNameLookup, (long)this.id, (String)this.name, (ConstraintType)this.constraintRuleType.asConstraintType(), (SchemaDescriptor)this.schema, (Long)this.ownedIndex, null);
        }

        @Override
        public SchemaRule convertTo50rule() {
            ExistenceConstraintDescriptor constraint;
            switch (this.constraintRuleType) {
                case UNIQUE: {
                    Preconditions.checkState((this.indexType == IndexType.RANGE ? 1 : 0) != 0, (String)("Unsupported migration for constraint schema rule backed by BTREE index type. Id: " + this.id));
                    constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema, (org.neo4j.internal.schema.IndexType)this.indexType.convertIndexType());
                    if (this.ownedIndex == null) break;
                    constraint = constraint.withOwnedIndexId(this.ownedIndex.longValue());
                    break;
                }
                case EXISTS: {
                    constraint = ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)this.schema);
                    break;
                }
                case UNIQUE_EXISTS: {
                    Preconditions.checkState((this.indexType == IndexType.RANGE ? 1 : 0) != 0, (String)("Unsupported migration for constraint schema rule backed by BTREE index type. Id: " + this.id));
                    constraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)this.schema, (org.neo4j.internal.schema.IndexType)this.indexType.convertIndexType());
                    if (this.ownedIndex == null) break;
                    constraint = constraint.withOwnedIndexId(this.ownedIndex.longValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported migration for constraint of type " + this.constraintRuleType.name());
                }
            }
            return constraint.withId(this.id).withName(this.name);
        }
    }

    public record Index(long id, SchemaDescriptor schema, boolean unique, String name, IndexType indexType, IndexProviderDescriptor providerDescriptor, IndexConfig indexConfig, Long owningConstraintId) implements SchemaRule44
    {
        @Override
        public String userDescription(TokenNameLookup tokenNameLookup) {
            return SchemaUserDescription.forIndex((TokenNameLookup)tokenNameLookup, (long)this.id, (String)this.name, (String)this.indexType.name(), (SchemaDescriptor)this.schema, (IndexProviderDescriptor)this.providerDescriptor, (Long)this.owningConstraintId);
        }

        @Override
        public SchemaRule convertTo50rule() {
            Preconditions.checkState((this.indexType != IndexType.BTREE ? 1 : 0) != 0, (String)("Unsupported migration for schema rule with BTREE index type. Id: " + this.id));
            IndexPrototype prototype = this.unique ? IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema) : IndexPrototype.forSchema((SchemaDescriptor)this.schema);
            prototype = prototype.withName(this.name).withIndexType(this.indexType.convertIndexType()).withIndexProvider(this.providerDescriptor);
            IndexDescriptor index = prototype.materialise(this.id);
            index = index.withIndexConfig(this.indexConfig);
            if (this.owningConstraintId != null) {
                index = index.withOwningConstraintId(this.owningConstraintId.longValue());
            }
            return index;
        }
    }
}

