/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.InnerTransactionHandler;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public interface KernelTransaction
extends AssertOpen,
AutoCloseable {
    public static final long ROLLBACK_ID = -1L;
    public static final long READ_ONLY_ID = 0L;
    public static final KernelTransactionMonitor NO_MONITOR = new KernelTransactionMonitor(){

        @Override
        public void beforeApply() {
        }

        @Override
        public void afterCommit(ExecutionStatistics statistics) {
        }
    };

    public long commit(KernelTransactionMonitor var1) throws TransactionFailureException;

    default public long commit() throws TransactionFailureException {
        return this.commit(NO_MONITOR);
    }

    public void rollback() throws TransactionFailureException;

    public Read dataRead();

    public Write dataWrite() throws InvalidTransactionTypeKernelException;

    public TokenRead tokenRead();

    public TokenWrite tokenWrite();

    public Token token();

    public SchemaRead schemaRead();

    public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException;

    public Locks locks();

    public CursorFactory cursors();

    public Procedures procedures();

    public ExecutionStatistics executionStatistics();

    public long closeTransaction() throws TransactionFailureException;

    @Override
    public void close() throws TransactionFailureException;

    public boolean isOpen();

    public boolean isClosing();

    default public Optional<Status> getReasonIfTerminated() {
        return this.getTerminationMark().map(info -> info.getReason());
    }

    public Optional<TerminationMark> getTerminationMark();

    public boolean isTerminated();

    public void markForTermination(Status var1);

    public void setMetaData(Map<String, Object> var1);

    public Map<String, Object> getMetaData();

    public void setStatusDetails(String var1);

    public String statusDetails();

    public Statement acquireStatement();

    public ResourceMonitor resourceMonitor();

    public IndexDescriptor indexUniqueCreate(IndexPrototype var1) throws KernelException;

    public SecurityContext securityContext();

    public SecurityAuthorizationHandler securityAuthorizationHandler();

    public ClientConnectionInfo clientInfo();

    public AuthSubject subjectOrAnonymous();

    public void bindToUserTransaction(InternalTransaction var1);

    public InternalTransaction internalTransaction();

    public long startTime();

    public long startTimeNanos();

    public TransactionTimeout timeout();

    public Type transactionType();

    public long getTransactionId();

    public long getTransactionSequenceNumber();

    public long getCommitTime();

    public Revertable overrideWith(SecurityContext var1);

    public ClockContext clocks();

    public NodeCursor ambientNodeCursor();

    public RelationshipScanCursor ambientRelationshipCursor();

    public PropertyCursor ambientPropertyCursor();

    public boolean isSchemaTransaction();

    public CursorContext cursorContext();

    public ExecutionContext createExecutionContext();

    public QueryContext queryContext();

    public StoreCursors storeCursors();

    public MemoryTracker memoryTracker();

    public UUID getDatabaseId();

    public String getDatabaseName();

    public boolean canCommit();

    public InnerTransactionHandler getInnerTransactionHandler();

    default public boolean isVirtualTransaction() {
        return false;
    }

    public static interface KernelTransactionMonitor {
        public void beforeApply();

        public void afterCommit(ExecutionStatistics var1);

        public static KernelTransactionMonitor withBeforeApply(final Runnable beforeApply) {
            return new KernelTransactionMonitor(){

                @Override
                public void beforeApply() {
                    beforeApply.run();
                }

                @Override
                public void afterCommit(ExecutionStatistics statistics) {
                }
            };
        }

        public static KernelTransactionMonitor withAfterCommit(final Consumer<ExecutionStatistics> onFinalStatistics) {
            return new KernelTransactionMonitor(){

                @Override
                public void beforeApply() {
                }

                @Override
                public void afterCommit(ExecutionStatistics statistics) {
                    onFinalStatistics.accept(statistics);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Revertable
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static enum Type {
        IMPLICIT,
        EXPLICIT;

    }
}

