/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.enrichment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.enrichment.TxMetadata;
import org.neo4j.storageengine.api.enrichment.WriteEnrichmentChannel;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Enrichment {
    protected final TxMetadata metadata;

    protected Enrichment(TxMetadata metadata) {
        this.metadata = metadata;
    }

    public abstract void serialize(WritableChannel var1) throws IOException;

    public TxMetadata metadata() {
        return this.metadata;
    }

    public static final class Write
    extends Enrichment
    implements AutoCloseable {
        private final WriteEnrichmentChannel entities;
        private final WriteEnrichmentChannel details;
        private final WriteEnrichmentChannel changes;
        private final WriteEnrichmentChannel values;
        private final WriteEnrichmentChannel userMetadata;

        private Write(TxMetadata metadata, WriteEnrichmentChannel entities, WriteEnrichmentChannel details, WriteEnrichmentChannel changes, WriteEnrichmentChannel values, WriteEnrichmentChannel userMetadata) {
            super(metadata);
            this.entities = Objects.requireNonNull(entities);
            this.details = Objects.requireNonNull(details);
            this.changes = Objects.requireNonNull(changes);
            this.values = Objects.requireNonNull(values);
            this.userMetadata = userMetadata;
        }

        public static Write createV5_8(TxMetadata metadata, WriteEnrichmentChannel entities, WriteEnrichmentChannel details, WriteEnrichmentChannel changes, WriteEnrichmentChannel values) {
            return new Write(metadata, entities, details, changes, values, null);
        }

        public static Write createV5_12(TxMetadata metadata, WriteEnrichmentChannel entities, WriteEnrichmentChannel details, WriteEnrichmentChannel changes, WriteEnrichmentChannel values, WriteEnrichmentChannel userMetadata) {
            return new Write(metadata, entities, details, changes, values, userMetadata);
        }

        public long totalSize() {
            boolean includeUserMetadata = this.userMetadata != null;
            int sizesFactor = includeUserMetadata ? 5 : 4;
            return 4 * sizesFactor + this.entities.size() + this.details.size() + this.changes.size() + this.values.size() + (includeUserMetadata ? this.userMetadata.size() : 0);
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            boolean includeUserMetadata = this.userMetadata != null;
            this.metadata.serialize(channel);
            channel.putInt(this.entities.size());
            channel.putInt(this.details.size());
            channel.putInt(this.changes.size());
            channel.putInt(this.values.size());
            if (includeUserMetadata) {
                channel.putInt(this.userMetadata.size());
            }
            this.entities.serialize(channel);
            this.details.serialize(channel);
            this.changes.serialize(channel);
            this.values.serialize(channel);
            if (includeUserMetadata) {
                this.userMetadata.serialize(channel);
            }
        }

        @Override
        public void close() {
            this.entities.close();
            this.details.close();
            this.changes.close();
            this.values.close();
            if (this.userMetadata != null) {
                this.userMetadata.close();
            }
        }
    }

    public static final class Read
    extends Enrichment
    implements AutoCloseable {
        private final KernelVersion kernelVersion;
        private final int entityCount;
        private final ByteBuffer entitiesBuffer;
        private final ByteBuffer detailsBuffer;
        private final ByteBuffer changesBuffer;
        private final ByteBuffer valuesBuffer;
        private final ByteBuffer userMetadataBuffer;
        private final MemoryTracker memoryTracker;

        private Read(KernelVersion kernelVersion, TxMetadata metadata, int entityCount, ByteBuffer entitiesBuffer, ByteBuffer detailsBuffer, ByteBuffer changesBuffer, ByteBuffer valuesBuffer, ByteBuffer userMetadataBuffer, MemoryTracker memoryTracker) {
            super(metadata);
            this.kernelVersion = kernelVersion;
            this.entityCount = entityCount;
            this.entitiesBuffer = entitiesBuffer;
            this.detailsBuffer = detailsBuffer;
            this.changesBuffer = changesBuffer;
            this.valuesBuffer = valuesBuffer;
            this.userMetadataBuffer = userMetadataBuffer;
            this.memoryTracker = memoryTracker;
        }

        public static Read deserialize(KernelVersion kernelVersion, ReadableChannel channel, MemoryTracker memoryTracker) throws IOException {
            TxMetadata txMetadata = TxMetadata.deserialize(channel);
            int entitiesSize = channel.getInt();
            int detailsSize = channel.getInt();
            int changesSize = channel.getInt();
            int valuesSize = channel.getInt();
            int userMetadataSize = 0;
            if (kernelVersion.isAtLeast(KernelVersion.VERSION_CDC_USER_METADATA_INTRODUCED)) {
                userMetadataSize = channel.getInt();
            }
            return new Read(kernelVersion, txMetadata, entitiesSize / 4, Read.readIntoBuffer(channel, entitiesSize, memoryTracker), Read.readIntoBuffer(channel, detailsSize, memoryTracker), Read.readIntoBuffer(channel, changesSize, memoryTracker), Read.readIntoBuffer(channel, valuesSize, memoryTracker), Read.readUserMetadataBuffer(channel, userMetadataSize, memoryTracker), memoryTracker);
        }

        private static ByteBuffer readIntoBuffer(ReadableChannel channel, int size, MemoryTracker memoryTracker) throws IOException {
            memoryTracker.allocateHeap((long)size);
            ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
            int read = channel.read(buffer);
            assert (read == size) : "Unable to read all the expected data into the buffer";
            return buffer.flip();
        }

        private static ByteBuffer readUserMetadataBuffer(ReadableChannel channel, int size, MemoryTracker memoryTracker) throws IOException {
            if (size <= 0) {
                return null;
            }
            return Read.readIntoBuffer(channel, size, memoryTracker);
        }

        private static ByteBuffer slice(ByteBuffer buffer) {
            return buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        }

        public KernelVersion kernelVersion() {
            return this.kernelVersion;
        }

        public int numberOfEntities() {
            return this.entityCount;
        }

        public ByteBuffer entities() {
            return Read.slice(this.entitiesBuffer);
        }

        public ByteBuffer entityDetails() {
            return Read.slice(this.detailsBuffer);
        }

        public ByteBuffer entityChanges() {
            return Read.slice(this.changesBuffer);
        }

        public ByteBuffer values() {
            return Read.slice(this.valuesBuffer);
        }

        public Optional<ByteBuffer> userMetadata() {
            if (this.userMetadataBuffer == null) {
                return Optional.empty();
            }
            return Optional.of(Read.slice(this.userMetadataBuffer));
        }

        @Override
        public void serialize(WritableChannel channel) throws IOException {
            this.metadata.serialize(channel);
            channel.putInt(this.entitiesBuffer.capacity()).putInt(this.detailsBuffer.capacity()).putInt(this.changesBuffer.capacity()).putInt(this.valuesBuffer.capacity());
            if (this.kernelVersion.isAtLeast(KernelVersion.VERSION_CDC_USER_METADATA_INTRODUCED)) {
                channel.putInt(this.userMetadataBuffer == null ? 0 : this.userMetadataBuffer.capacity());
            }
            channel.putAll(Read.slice(this.entitiesBuffer)).putAll(Read.slice(this.detailsBuffer)).putAll(Read.slice(this.changesBuffer)).putAll(Read.slice(this.valuesBuffer));
            if (this.userMetadataBuffer != null) {
                channel.putAll(Read.slice(this.userMetadataBuffer));
            }
        }

        @Override
        public void close() {
            this.memoryTracker.releaseHeap((long)this.entitiesBuffer.capacity());
            this.memoryTracker.releaseHeap((long)this.detailsBuffer.capacity());
            this.memoryTracker.releaseHeap((long)this.changesBuffer.capacity());
            this.memoryTracker.releaseHeap((long)this.valuesBuffer.capacity());
            if (this.userMetadataBuffer != null) {
                this.memoryTracker.releaseHeap((long)this.userMetadataBuffer.capacity());
            }
        }
    }
}

