/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.nio.file.Path;
import org.neo4j.internal.schema.IndexProviderDescriptor;

public abstract class IndexDirectoryStructure {
    private static final IndexDirectoryStructure NO_DIRECTORY_STRUCTURE = new IndexDirectoryStructure(){

        @Override
        public Path rootDirectory() {
            return null;
        }

        @Override
        public Path directoryForIndex(long indexId) {
            return null;
        }
    };
    public static final Factory NONE = descriptor -> NO_DIRECTORY_STRUCTURE;

    public static Path baseSchemaIndexFolder(Path databaseStoreDir) {
        return databaseStoreDir.resolve("schema").resolve("index");
    }

    public static Factory directoriesByProvider(Path databaseStoreDir) {
        return descriptor -> new SubDirectoryByIndexId(IndexDirectoryStructure.baseSchemaIndexFolder(databaseStoreDir).resolve(IndexDirectoryStructure.fileNameFriendly(descriptor)));
    }

    public static Factory given(IndexDirectoryStructure directoryStructure) {
        return descriptor -> directoryStructure;
    }

    public static String fileNameFriendly(String name) {
        return name.replaceAll("\\+", "_");
    }

    static String fileNameFriendly(IndexProviderDescriptor descriptor) {
        return IndexDirectoryStructure.fileNameFriendly(descriptor.getKey() + "-" + descriptor.getVersion());
    }

    public abstract Path rootDirectory();

    public abstract Path directoryForIndex(long var1);

    public static interface Factory {
        public IndexDirectoryStructure forProvider(IndexProviderDescriptor var1);
    }

    private static class SubDirectoryByIndexId
    extends IndexDirectoryStructure {
        private final Path providerRootFolder;

        private SubDirectoryByIndexId(Path providerRootFolder) {
            this.providerRootFolder = providerRootFolder;
        }

        @Override
        public Path rootDirectory() {
            return this.providerRootFolder;
        }

        @Override
        public Path directoryForIndex(long indexId) {
            return this.providerRootFolder.resolve(String.valueOf(indexId));
        }
    }
}

