/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.Segment;

public class AdminActionOnResource {
    private final PrivilegeAction action;
    private final DatabaseScope databaseScope;
    private final Segment segment;
    public static final AdminActionOnResource ALL = new AdminActionOnResource(PrivilegeAction.ADMIN, DatabaseScope.ALL, Segment.ALL);

    public AdminActionOnResource(PrivilegeAction action, DatabaseScope databaseScope, Segment segment) {
        this.action = action;
        this.databaseScope = databaseScope;
        this.segment = segment;
    }

    public boolean matches(AdminActionOnResource request) {
        return this.action.satisfies(request.action) && (this.databaseScope.all || this.databaseScope.name.equals(request.databaseScope.name)) && this.segment.satisfies(request.segment);
    }

    public static class DatabaseScope {
        private final String name;
        private final boolean all;
        public static final DatabaseScope ALL = new DatabaseScope("*", true);

        public DatabaseScope(String name) {
            this(name, false);
        }

        private DatabaseScope(String name, boolean all) {
            this.name = name;
            this.all = all;
        }
    }
}

