/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Objects;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.EntityAlreadyExistsException;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.values.storable.Value;

public interface Write {
    public long nodeCreate();

    public void nodeWithSpecificIdCreate(long var1) throws EntityAlreadyExistsException;

    public long nodeCreateWithLabels(int[] var1) throws ConstraintValidationException;

    public void nodeWithSpecificIdCreateWithLabels(long var1, int[] var3) throws EntityAlreadyExistsException, ConstraintValidationException;

    public boolean nodeDelete(long var1);

    default public int nodeDetachDelete(long node) throws KernelException {
        return this.nodeDetachDelete(node, (id, type, sourceNodeReference, targetNodeReference) -> {});
    }

    public int nodeDetachDelete(long var1, DetachDeleteConsumer var3) throws KernelException;

    public long relationshipCreate(long var1, int var3, long var4) throws EntityNotFoundException;

    public void relationshipWithSpecificIdCreate(long var1, long var3, int var5, long var6) throws EntityAlreadyExistsException, EntityNotFoundException;

    public boolean relationshipDelete(long var1);

    public boolean nodeAddLabel(long var1, int var3) throws KernelException;

    public boolean nodeRemoveLabel(long var1, int var3) throws EntityNotFoundException;

    public void nodeSetProperty(long var1, int var3, Value var4) throws KernelException;

    public void nodeApplyChanges(long var1, IntSet var3, IntSet var4, IntObjectMap<Value> var5) throws EntityNotFoundException, ConstraintValidationException;

    public void relationshipApplyChanges(long var1, IntObjectMap<Value> var3) throws EntityNotFoundException, ConstraintValidationException;

    public Value nodeRemoveProperty(long var1, int var3) throws EntityNotFoundException;

    public void relationshipSetProperty(long var1, int var3, Value var4) throws EntityNotFoundException, ConstraintValidationException;

    public Value relationshipRemoveProperty(long var1, int var3) throws EntityNotFoundException;

    @FunctionalInterface
    public static interface DetachDeleteConsumer {
        public void accept(long var1, int var3, long var4, long var6);

        default public DetachDeleteConsumer andThen(DetachDeleteConsumer after) {
            Objects.requireNonNull(after);
            return (id, type, sourceNodeReference, targetNodeReference) -> {
                this.accept(id, type, sourceNodeReference, targetNodeReference);
                after.accept(id, type, sourceNodeReference, targetNodeReference);
            };
        }
    }
}

