/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public class IndexEntryConflictException
extends KernelException {
    private final ValueTuple propertyValues;
    private final long addedEntityId;
    private final long existingEntityId;

    public IndexEntryConflictException(String message, Throwable cause) {
        super((Status)Status.Schema.ConstraintViolation, message, new Object[]{cause});
        this.propertyValues = null;
        this.addedEntityId = -1L;
        this.existingEntityId = -1L;
    }

    public IndexEntryConflictException(EntityType entityType, long existingEntityId, long addedEntityId, Value ... propertyValue) {
        this(entityType, existingEntityId, addedEntityId, ValueTuple.of((Value[])propertyValue));
    }

    public IndexEntryConflictException(EntityType entityType, long existingEntityId, long addedEntityId, ValueTuple propertyValues) {
        super((Status)Status.Schema.ConstraintViolation, "Both %s %d and %s %d share the property value %s", new Object[]{entityType == EntityType.NODE ? "node" : "relationship", existingEntityId, entityType == EntityType.NODE ? "node" : "relationship", addedEntityId, propertyValues});
        this.existingEntityId = existingEntityId;
        this.addedEntityId = addedEntityId;
        this.propertyValues = propertyValues;
    }

    public String evidenceMessage(TokenNameLookup tokenNameLookup, SchemaDescriptor schema) {
        String tokenName;
        String entityName;
        assert (schema.getPropertyIds().length == this.propertyValues.size());
        if (schema.entityType() == EntityType.NODE) {
            entityName = "Node";
            tokenName = Arrays.stream(schema.getEntityTokenIds()).mapToObj(arg_0 -> ((TokenNameLookup)tokenNameLookup).labelGetName(arg_0)).collect(Collectors.joining("`, `", "label `", "`"));
        } else {
            entityName = "Relationship";
            tokenName = Arrays.stream(schema.getEntityTokenIds()).mapToObj(arg_0 -> ((TokenNameLookup)tokenNameLookup).relationshipTypeGetName(arg_0)).collect(Collectors.joining("`, `", "relationship type `", "`"));
        }
        if (this.addedEntityId == -1L) {
            return String.format("%s(%d) already exists with %s and %s", entityName, this.existingEntityId, tokenName, this.propertyString(tokenNameLookup, schema.getPropertyIds()));
        }
        return String.format("Both %s(%d) and %s(%d) have the %s and %s", entityName, this.existingEntityId, entityName, this.addedEntityId, tokenName, this.propertyString(tokenNameLookup, schema.getPropertyIds()));
    }

    public ValueTuple getPropertyValues() {
        return this.propertyValues;
    }

    public Value getSinglePropertyValue() {
        return this.propertyValues.getOnlyValue();
    }

    public long getAddedEntityId() {
        return this.addedEntityId;
    }

    public long getExistingEntityId() {
        return this.existingEntityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IndexEntryConflictException that = (IndexEntryConflictException)((Object)o);
        return this.addedEntityId == that.addedEntityId && this.existingEntityId == that.existingEntityId && !(this.propertyValues == null ? that.propertyValues != null : !this.propertyValues.equals((Object)that.propertyValues));
    }

    public int hashCode() {
        int result = this.propertyValues != null ? this.propertyValues.hashCode() : 0;
        result = 31 * result + (int)(this.addedEntityId ^ this.addedEntityId >>> 32);
        result = 31 * result + (int)(this.existingEntityId ^ this.existingEntityId >>> 32);
        return result;
    }

    public String toString() {
        return "IndexEntryConflictException{propertyValues=" + this.propertyValues + ", addedEntityId=" + this.addedEntityId + ", existingEntityId=" + this.existingEntityId + "}";
    }

    private String propertyString(TokenNameLookup tokenNameLookup, int[] propertyIds) {
        StringBuilder sb = new StringBuilder();
        String sep = propertyIds.length > 1 ? "properties " : "property ";
        for (int i = 0; i < propertyIds.length; ++i) {
            sb.append(sep);
            sep = ", ";
            sb.append('`');
            sb.append(tokenNameLookup.propertyKeyGetName(propertyIds[i]));
            sb.append("` = ");
            sb.append(this.propertyValues.valueAt(i).prettyPrint());
        }
        return sb.toString();
    }
}

