/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public record PatternSegment(Set<String> labels, String property, Value value, boolean equals) implements Segment
{
    private static final Set<String> EMPTY = Set.of();

    public PatternSegment(String property, Value value, boolean equals) {
        this(EMPTY, property, value, equals);
    }

    public PatternSegment {
        Objects.requireNonNull(labels, "labels must not be null");
        Objects.requireNonNull(property, "property must not be null");
        Objects.requireNonNull(value, "value must not be null");
    }

    @Override
    public String toString() {
        String labelsString = this.labels.isEmpty() ? "" : this.labels.stream().sorted().collect(Collectors.joining("|", ":", ""));
        String nodeString = String.format("(n%s)", labelsString);
        String propertyString = String.format("n.%s", this.property);
        String predicateString = this.value == Values.NO_VALUE ? (this.equals ? "IS NULL" : "IS NOT NULL") : (this.equals ? "= " : "<> ") + this.value.prettyPrint();
        return String.format("FOR %s WHERE %s %s", nodeString, propertyString, predicateString);
    }

    @Override
    public boolean satisfies(Segment segment) {
        throw new UnsupportedOperationException();
    }
}

