/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate.validation;

import java.util.Arrays;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.api.exceptions.Status;

public class TransactionConflictException
extends RuntimeException
implements Status.HasStatus {
    private static final String GENERIC_MESSAGE = "Transaction conflict validation failed.";
    private DatabaseFile databaseFile;
    private long observedVersion;
    private long highestClosed;
    private long[] nonVisibleTransactions;
    private final String message;

    public TransactionConflictException(DatabaseFile databaseFile, VersionContext versionContext) {
        this.databaseFile = databaseFile;
        this.observedVersion = versionContext.chainHeadVersion();
        this.highestClosed = versionContext.highestClosed();
        this.nonVisibleTransactions = versionContext.notVisibleTransactionIds();
        this.message = this.createMessage();
    }

    public TransactionConflictException(Exception e) {
        super(e);
        this.message = GENERIC_MESSAGE;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public DatabaseFile getDatabaseFile() {
        return this.databaseFile;
    }

    public long getObservedVersion() {
        return this.observedVersion;
    }

    public long getHighestClosed() {
        return this.highestClosed;
    }

    public long[] getNonVisibleTransactions() {
        return this.nonVisibleTransactions;
    }

    public Status status() {
        return Status.Transaction.Outdated;
    }

    private String createMessage() {
        return "Concurrent modification exception. Page in " + this.databaseFile.getName() + " store is modified already by transaction " + this.observedVersion + ", while ongoing transaction highest visible is: " + this.highestClosed + ", with not yet visible transaction ids are: " + Arrays.toString(this.nonVisibleTransactions) + ".";
    }
}

