/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Objects;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public record LabelPropertySegment(String label, String property, Value value, boolean equals) implements Segment
{
    public LabelPropertySegment(String property, Value value, boolean equals) {
        this(null, property, value, equals);
    }

    public LabelPropertySegment(String label, String property, Value value, boolean equals) {
        Objects.requireNonNull(property, "property must not be null");
        Objects.requireNonNull(value, "value must not be null");
        this.property = property;
        this.value = value;
        this.equals = equals;
        this.label = Objects.equals(label, "*") ? null : label;
    }

    @Override
    public String toString() {
        String nodeString = String.format("(n%s)", this.label == null ? "" : ":" + this.label);
        String propertyString = String.format("n.%s", this.property);
        String predicateString = this.value == Values.NO_VALUE ? (this.equals ? "IS NULL" : "IS NOT NULL") : (this.equals ? "= " : "<> ") + this.value.prettyPrint();
        return String.format("FOR %s WHERE %s %s", nodeString, propertyString, predicateString);
    }

    @Override
    public boolean satisfies(Segment segment) {
        throw new UnsupportedOperationException();
    }
}

