/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.util.Map;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.token.TokenHolders;

public interface Input
extends AutoCloseable {
    public InputIterable nodes(Collector var1);

    public InputIterable relationships(Collector var1);

    public IdType idType();

    public ReadableGroups groups();

    public Estimates calculateEstimates(PropertySizeCalculator var1) throws IOException;

    default public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void close() {
    }

    public static Input input(final InputIterable nodes, final InputIterable relationships, final IdType idType, final Estimates estimates, final ReadableGroups groups) {
        return new Input(){

            @Override
            public InputIterable relationships(Collector badCollector) {
                return relationships;
            }

            @Override
            public InputIterable nodes(Collector badCollector) {
                return nodes;
            }

            @Override
            public IdType idType() {
                return idType;
            }

            @Override
            public ReadableGroups groups() {
                return groups;
            }

            @Override
            public Estimates calculateEstimates(PropertySizeCalculator valueSizeCalculator) {
                return estimates;
            }
        };
    }

    public static Estimates knownEstimates(long numberOfNodes, long numberOfRelationships, long numberOfNodeProperties, long numberOfRelationshipProperties, long sizeOfNodeProperties, long sizeOfRelationshipProperties, long numberOfNodeLabels) {
        return new Estimates(numberOfNodes, numberOfRelationships, numberOfNodeProperties, numberOfRelationshipProperties, sizeOfNodeProperties, sizeOfRelationshipProperties, numberOfNodeLabels);
    }

    public record Estimates(long numberOfNodes, long numberOfRelationships, long numberOfNodeProperties, long numberOfRelationshipProperties, long sizeOfNodeProperties, long sizeOfRelationshipProperties, long numberOfNodeLabels) {
    }
}

