/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public abstract class IndexEntryUpdate<INDEX_KEY extends SchemaDescriptorSupplier> {
    private final long entityId;
    private final UpdateMode updateMode;
    private final INDEX_KEY indexKey;

    IndexEntryUpdate(long entityId, INDEX_KEY indexKey, UpdateMode updateMode) {
        this.entityId = entityId;
        this.indexKey = indexKey;
        this.updateMode = updateMode;
    }

    public final long getEntityId() {
        return this.entityId;
    }

    public UpdateMode updateMode() {
        return this.updateMode;
    }

    public INDEX_KEY indexKey() {
        return this.indexKey;
    }

    public boolean equals(Object o) {
        boolean schemaEquals;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntryUpdate that = (IndexEntryUpdate)o;
        if (this.entityId != that.entityId) {
            return false;
        }
        if (this.updateMode != that.updateMode) {
            return false;
        }
        boolean bl = this.indexKey != null ? this.indexKey.schema().equals(that.indexKey.schema()) : (schemaEquals = that.indexKey == null);
        if (!schemaEquals) {
            return false;
        }
        return this.valueEquals(that);
    }

    public int hashCode() {
        int result = (int)(this.entityId ^ this.entityId >>> 32);
        result = 31 * result + (this.updateMode != null ? this.updateMode.hashCode() : 0);
        result = 31 * result + (this.indexKey != null ? this.indexKey.schema().hashCode() : 0);
        result = 31 * result + this.valueHash();
        return result;
    }

    public String describe(TokenNameLookup tokenNameLookup) {
        return String.format(this.getClass().getSimpleName() + "[id=%d, mode=%s, %s, %s]", new Object[]{this.entityId, this.updateMode, this.indexKey().schema().userDescription(tokenNameLookup), this.valueToString()});
    }

    public abstract long roughSizeOfUpdate();

    protected abstract boolean valueEquals(IndexEntryUpdate<?> var1);

    protected abstract int valueHash();

    protected abstract String valueToString();

    public static <INDEX_KEY extends SchemaDescriptorSupplier> ValueIndexEntryUpdate<INDEX_KEY> add(long entityId, INDEX_KEY indexKey, Value ... values) {
        return new ValueIndexEntryUpdate<INDEX_KEY>(entityId, indexKey, UpdateMode.ADDED, values);
    }

    public static <INDEX_KEY extends SchemaDescriptorSupplier> ValueIndexEntryUpdate<INDEX_KEY> remove(long entityId, INDEX_KEY indexKey, Value ... values) {
        return new ValueIndexEntryUpdate<INDEX_KEY>(entityId, indexKey, UpdateMode.REMOVED, values);
    }

    public static <INDEX_KEY extends SchemaDescriptorSupplier> ValueIndexEntryUpdate<INDEX_KEY> change(long entityId, INDEX_KEY indexKey, Value before, Value after) {
        return new ValueIndexEntryUpdate<INDEX_KEY>(entityId, indexKey, UpdateMode.CHANGED, new Value[]{before}, new Value[]{after});
    }

    public static <INDEX_KEY extends SchemaDescriptorSupplier> ValueIndexEntryUpdate<INDEX_KEY> change(long entityId, INDEX_KEY indexKey, Value[] before, Value[] after) {
        return new ValueIndexEntryUpdate<INDEX_KEY>(entityId, indexKey, UpdateMode.CHANGED, before, after);
    }

    public static <INDEX_KEY extends SchemaDescriptorSupplier> TokenIndexEntryUpdate<INDEX_KEY> change(long entityId, INDEX_KEY indexKey, long[] before, long[] after) {
        return IndexEntryUpdate.change(entityId, indexKey, before, after, false);
    }

    public static <INDEX_KEY extends SchemaDescriptorSupplier> TokenIndexEntryUpdate<INDEX_KEY> change(long entityId, INDEX_KEY indexKey, long[] before, long[] after, boolean logical) {
        return new TokenIndexEntryUpdate<INDEX_KEY>(entityId, indexKey, before, after, logical);
    }
}

