/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;

public final class UserFunctionSignature {
    private final QualifiedName name;
    private final List<FieldSignature> inputSignature;
    private final Neo4jTypes.AnyType type;
    private final String[] allowed;
    private final String deprecated;
    private final String description;
    private final String category;
    private final boolean caseInsensitive;
    private final boolean isBuiltIn;

    public UserFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, String deprecated, String[] allowed, String description, String category, boolean caseInsensitive) {
        this.name = name;
        this.inputSignature = Collections.unmodifiableList(inputSignature);
        this.type = type;
        this.deprecated = deprecated;
        this.description = description;
        this.category = category;
        this.allowed = allowed;
        this.caseInsensitive = caseInsensitive;
        this.isBuiltIn = false;
    }

    public UserFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, String deprecated, String[] allowed, String description, String category, boolean caseInsensitive, boolean isBuiltIn) {
        this.name = name;
        this.inputSignature = Collections.unmodifiableList(inputSignature);
        this.type = type;
        this.deprecated = deprecated;
        this.description = description;
        this.category = category;
        this.allowed = allowed;
        this.caseInsensitive = caseInsensitive;
        this.isBuiltIn = isBuiltIn;
    }

    public QualifiedName name() {
        return this.name;
    }

    public Optional<String> deprecated() {
        return Optional.ofNullable(this.deprecated);
    }

    public List<FieldSignature> inputSignature() {
        return this.inputSignature;
    }

    public Neo4jTypes.AnyType outputType() {
        return this.type;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> category() {
        return Optional.ofNullable(this.category);
    }

    public String[] allowed() {
        return this.allowed;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFunctionSignature that = (UserFunctionSignature)o;
        return this.name.equals(that.name) && this.inputSignature.equals(that.inputSignature) && this.type.equals(that.type);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String strInSig = this.inputSignature == null ? "..." : Iterables.toString(this.inputSignature, (String)", ");
        String strOutSig = this.type == null ? "..." : this.type.toString();
        return String.format("%s(%s) :: (%s)", this.name, strInSig, strOutSig);
    }

    public static Builder functionSignature(String ... namespaceAndName) {
        String[] namespace = namespaceAndName.length > 1 ? Arrays.copyOf(namespaceAndName, namespaceAndName.length - 1) : new String[]{};
        String name = namespaceAndName[namespaceAndName.length - 1];
        return UserFunctionSignature.functionSignature(namespace, name);
    }

    public static Builder functionSignature(QualifiedName name) {
        return new Builder(name.namespace(), name.name());
    }

    public static Builder functionSignature(String[] namespace, String name) {
        return new Builder(namespace, name);
    }

    public static class Builder {
        private final QualifiedName name;
        private final List<FieldSignature> inputSignature = new LinkedList<FieldSignature>();
        private Neo4jTypes.AnyType outputType;
        private String[] allowed = new String[0];
        private String deprecated;
        private String description;
        private String category;

        public Builder(String[] namespace, String name) {
            this.name = new QualifiedName(namespace, name);
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder deprecatedBy(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder in(String name, Neo4jTypes.AnyType type) {
            this.inputSignature.add(FieldSignature.inputField(name, type));
            return this;
        }

        public Builder in(String name, Neo4jTypes.AnyType type, DefaultParameterValue defaultValue) {
            this.inputSignature.add(FieldSignature.inputField(name, type, defaultValue));
            return this;
        }

        public Builder out(Neo4jTypes.AnyType type) {
            this.outputType = type;
            return this;
        }

        public Builder allowed(String[] allowed) {
            this.allowed = allowed;
            return this;
        }

        public UserFunctionSignature build() {
            if (this.outputType == null) {
                throw new IllegalStateException("output type must be set");
            }
            return new UserFunctionSignature(this.name, this.inputSignature, this.outputType, this.deprecated, this.allowed, this.description, this.category, false);
        }
    }
}

