/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.function.IntFunction;
import org.neo4j.storageengine.api.EntityType;

public interface TokenNameLookup {
    public String labelGetName(int var1);

    public String relationshipTypeGetName(int var1);

    public String propertyKeyGetName(int var1);

    default public String[] entityTokensGetNames(EntityType type, int[] entityTokenIds) {
        IntFunction<String> mapper;
        switch (type) {
            case NODE: {
                mapper = this::labelGetName;
                break;
            }
            case RELATIONSHIP: {
                mapper = this::relationshipTypeGetName;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot lookup names for tokens of type: " + (Object)((Object)type));
            }
        }
        String[] tokenNames = new String[entityTokenIds.length];
        for (int i = 0; i < entityTokenIds.length; ++i) {
            tokenNames[i] = mapper.apply(entityTokenIds[i]);
        }
        return tokenNames;
    }
}

