/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Iterator;
import java.util.List;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.values.storable.ValueCategory;

public interface IndexReference
extends IndexCapability {
    public static final String UNNAMED_INDEX = "Unnamed index";
    public static final IndexReference NO_INDEX = new IndexReference(){

        @Override
        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            return NO_CAPABILITY.orderCapability(valueCategories);
        }

        @Override
        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return NO_CAPABILITY.valueCapability(valueCategories);
        }

        @Override
        public boolean isUnique() {
            return false;
        }

        @Override
        public int[] properties() {
            return new int[0];
        }

        @Override
        public SchemaDescriptor schema() {
            return SchemaDescriptor.NO_SCHEMA;
        }

        @Override
        public String providerKey() {
            return null;
        }

        @Override
        public String providerVersion() {
            return null;
        }

        @Override
        public String name() {
            return IndexReference.UNNAMED_INDEX;
        }
    };

    public boolean isUnique();

    public int[] properties();

    public SchemaDescriptor schema();

    public String providerKey();

    public String providerVersion();

    public String name();

    default public String userDescription(TokenNameLookup tokenNameLookup) {
        String type = this.isUnique() ? "UNIQUE" : "GENERAL";
        return String.format("Index( %s, %s )", type, SchemaUtil.niceProperties(tokenNameLookup, this.properties()));
    }

    public static Iterator<IndexReference> sortByType(Iterator<IndexReference> indexes) {
        List materialized = Iterators.asList(indexes);
        return Iterators.concat((Iterator[])new Iterator[]{Iterators.filter(i -> !i.isUnique(), materialized.iterator()), Iterators.filter(IndexReference::isUnique, materialized.iterator())});
    }
}

